"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ArchiveItemRequest = void 0;
const ItemIdWrapperList_1 = require("../../Misc/ItemIdWrapperList");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ArchiveItemResponse_1 = require("../Responses/ArchiveItemResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class ArchiveItemRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingModeServiceErrorHandling) {
        super(service, errorHandlingModeServiceErrorHandling);
        this.ids = new ItemIdWrapperList_1.ItemIdWrapperList();
    }
    get Ids() { return this.ids; }
    get SourceFolderId() {
        return this.sourceFolderId;
    }
    set SourceFolderId(value) {
        this.sourceFolderId = value;
    }
    //AddIdsToJson(jsonObject: JsonObject, service: ExchangeService): any { throw new Error("ArchiveItemRequest.ts - AddIdsToJson : Not implemented."); }
    CreateServiceResponse(service, responseIndex) { return new ArchiveItemResponse_1.ArchiveItemResponse(); }
    GetExpectedResponseMessageCount() { return this.ids.Count; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2013; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.ArchiveItemResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.ArchiveItemResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.ArchiveItem; }
    Validate() {
        //EwsUtilities.ValidateParam(this.sourceFolderId, "SourceFolderId");
        this.sourceFolderId.Validate(this.Service.RequestedServerVersion);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ArchiveSourceFolderId);
        this.SourceFolderId.WriteToXml(writer);
        writer.WriteEndElement();
        this.WriteIdsToXml(writer);
    }
    /**@internal */
    WriteIdsToXml(writer) {
        this.Ids.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemIds);
    }
}
exports.ArchiveItemRequest = ArchiveItemRequest;
//# sourceMappingURL=ArchiveItemRequest.js.map