"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteRequest = void 0;
const DeleteMode_1 = require("../../Enumerations/DeleteMode");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class DeleteRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.deleteMode = DeleteMode_1.DeleteMode.SoftDelete;
    }
    get DeleteMode() {
        return this.deleteMode;
    }
    set DeleteMode(value) {
        this.deleteMode = value;
    }
    InternalToJson(body) { throw new Error("DeleteRequest.ts - InternalToJson : Not implemented."); }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.DeleteType, DeleteMode_1.DeleteMode[this.DeleteMode]);
    }
}
exports.DeleteRequest = DeleteRequest;
//# sourceMappingURL=DeleteRequest.js.map