"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteUserConfigurationRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const UserConfiguration_1 = require("../../Misc/UserConfiguration");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/**
 * @internal Represents a DeleteUserConfiguration request.
 */
class DeleteUserConfigurationRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **DeleteUserConfigurationRequest** class.
     *
     * @param   {ExchangeService}       service   The service.
     */
    constructor(service) {
        super(service, ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError);
        this.name = null;
        this.parentFolderId = null;
    }
    /**
     * @internal Gets or sets the name.
     *
     * @Value   The Name
     */
    get Name() {
        return this.name;
    }
    set Name(value) {
        this.name = value;
    }
    /**
     * @internal Gets or sets the parent folder Id.
     *
     * @value   The parent folder Id.
     */
    get ParentFolderId() {
        return this.parentFolderId;
    }
    set ParentFolderId(value) {
        this.parentFolderId = value;
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {ServiceResponse}	Service response.
     */
    CreateServiceResponse(service, responseIndex) {
        return new ServiceResponse_1.ServiceResponse();
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of expected response messages.
     */
    GetExpectedResponseMessageCount() {
        return 1;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2010;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DeleteUserConfigurationResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DeleteUserConfigurationResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      Xml element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DeleteUserConfiguration;
    }
    /**
     * @internal Validate the request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.name, "name");
        EwsUtilities_1.EwsUtilities.ValidateParam(this.parentFolderId, "parentFolderId");
        this.ParentFolderId.Validate(this.Service.RequestedServerVersion);
    }
    /**
     * @internal Writes XML elements.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        // Write UserConfiguationName element
        UserConfiguration_1.UserConfiguration.WriteUserConfigurationNameToXml(writer, XmlNamespace_1.XmlNamespace.Messages, this.name, this.parentFolderId);
    }
}
exports.DeleteUserConfigurationRequest = DeleteUserConfigurationRequest;
//# sourceMappingURL=DeleteUserConfigurationRequest.js.map