"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DisableAppRequest = void 0;
const DisableAppResponse_1 = require("../Responses/DisableAppResponse");
const DisableReasonType_1 = require("../../Enumerations/DisableReasonType");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a DisableApp request.
 *
 * @sealed
 */
class DisableAppRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **DisableAppRequest** class.
     *
     * @param   {ExchangeService}   	service         The service.
     * @param   {string}   				id              Extension id.
     * @param   {DisableReasonType}   	disableReason   Disable reason.
     */
    constructor(service, id, disableReason) {
        super(service);
        /**
         * Extension id
         */
        this.Id = null;
        /**
         * Disable reason
         */
        this.DisableReason = DisableReasonType_1.DisableReasonType.NoReason;
        this.Id = id;
        this.DisableReason = disableReason;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<DisableAppResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DisableAppResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DisableAppRequest;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new DisableAppResponse_1.DisableAppResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ID, this.Id);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.DisableReason, DisableReasonType_1.DisableReasonType[this.DisableReason]);
    }
}
exports.DisableAppRequest = DisableAppRequest;
//# sourceMappingURL=DisableAppRequest.js.map