"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindItemRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const FindItemResponse_1 = require("../Responses/FindItemResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const FindRequest_1 = require("./FindRequest");
/**
 * @internal Represents a **FindItem** request.
 *
 * @type <TItem>   Item type.
 */
class FindItemRequest extends FindRequest_1.FindRequest {
    /**
     * @internal Initializes a new instance of the **FindItemRequest** class.
     *
     * @param   {ExchangeService}       service             The service.
     * @param   {ServiceErrorHandling}  errorHandlingMode   Indicates how errors should be handled.
     */
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.groupBy = null;
    }
    /**
     * Gets or sets the group by.
     *
     * @value The group by.
     */
    get GroupBy() {
        return this.groupBy;
    }
    set GroupBy(value) {
        this.groupBy = value;
    }
    /**
     * Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}            responseIndex   Index of the response.
     * @return  {FindItemResponse<TItem>}           Service response.
     */
    CreateServiceResponse(service, responseIndex) { return new FindItemResponse_1.FindItemResponse(this.GroupBy != null, this.View.GetPropertySetOrDefault()); }
    /**
     * @internal Gets the group by clause.
     *
     * @return  {Grouping}      The group by clause, null if the request does not have or support grouping.
     */
    GetGroupBy() { return this.GroupBy; }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.FindItemResponseMessage; }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.FindItemResponse; }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string} XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.FindItem; }
}
exports.FindItemRequest = FindItemRequest;
//# sourceMappingURL=FindItemRequest.js.map