"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceVersionException_1 = require("../../Exceptions/ServiceVersionException");
const Strings_1 = require("../../Strings");
const SeekToConditionItemView_1 = require("../../Search/SeekToConditionItemView");
const ServiceLocalException_1 = require("../../Exceptions/ServiceLocalException");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const FolderIdWrapperList_1 = require("../../Misc/FolderIdWrapperList");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class FindRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    //private searchFilter: SearchFilter;  - no backing property needed
    //private queryString: string;
    //private returnHighlightTerms: boolean;
    //private view: ViewBase;
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.SearchFilter = null;
        this.QueryString = null;
        this.ReturnHighlightTerms = null;
        this.View = null;
        this.parentFolderIds = new FolderIdWrapperList_1.FolderIdWrapperList();
    }
    get ParentFolderIds() { return this.parentFolderIds; }
    GetExpectedResponseMessageCount() { return this.ParentFolderIds.Count; }
    GetGroupBy() { return null; }
    Validate() {
        super.Validate();
        this.View.InternalValidate(this);
        // query string parameter is only valid for Exchange2010 or higher
        //
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.QueryString) &&
            this.Service.RequestedServerVersion < ExchangeVersion_1.ExchangeVersion.Exchange2010) {
            throw new ServiceVersionException_1.ServiceVersionException(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.ParameterIncompatibleWithRequestVersion, "queryString", ExchangeVersion_1.ExchangeVersion[ExchangeVersion_1.ExchangeVersion.Exchange2010]));
        }
        // ReturnHighlightTerms parameter is only valid for Exchange2013 or higher
        //
        if (this.ReturnHighlightTerms &&
            this.Service.RequestedServerVersion < ExchangeVersion_1.ExchangeVersion.Exchange2013) {
            throw new ServiceVersionException_1.ServiceVersionException(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.ParameterIncompatibleWithRequestVersion, "returnHighlightTerms", ExchangeVersion_1.ExchangeVersion[ExchangeVersion_1.ExchangeVersion.Exchange2013]));
        }
        // SeekToConditionItemView is only valid for Exchange2013 or higher
        //
        if ((this.View instanceof SeekToConditionItemView_1.SeekToConditionItemView) &&
            this.Service.RequestedServerVersion < ExchangeVersion_1.ExchangeVersion.Exchange2013) {
            throw new ServiceVersionException_1.ServiceVersionException(ExtensionMethods_1.StringHelper.Format(Strings_1.Strings.ParameterIncompatibleWithRequestVersion, "SeekToConditionItemView", ExchangeVersion_1.ExchangeVersion[ExchangeVersion_1.ExchangeVersion.Exchange2013]));
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.QueryString) &&
            this.SearchFilter != null) {
            throw new ServiceLocalException_1.ServiceLocalException(Strings_1.Strings.BothSearchFilterAndQueryStringCannotBeSpecified);
        }
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        this.View.WriteAttributesToXml(writer);
    }
    /**@internal */
    WriteElementsToXml(writer) {
        this.View.WriteToXml(writer, this.GetGroupBy());
        if (this.SearchFilter != null) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Restriction);
            this.SearchFilter.WriteToXml(writer);
            writer.WriteEndElement(); // Restriction
        }
        this.View.WriteOrderByToXml(writer);
        this.ParentFolderIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ParentFolderIds);
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.QueryString)) {
            // Emit the QueryString
            //
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.QueryString);
            if (this.ReturnHighlightTerms) {
                writer.WriteAttributeString(XmlAttributeNames_1.XmlAttributeNames.ReturnHighlightTerms, this.ReturnHighlightTerms.toString());
            }
            writer.WriteValue(this.QueryString, XmlElementNames_1.XmlElementNames.QueryString);
            writer.WriteEndElement();
        }
    }
}
exports.FindRequest = FindRequest;
//# sourceMappingURL=FindRequest.js.map