"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetSearchableMailboxesRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetSearchableMailboxesResponse_1 = require("../Responses/GetSearchableMailboxesResponse");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetSearchableMailboxesRequest request.
 */
class GetSearchableMailboxesRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetSearchableMailboxesRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * Search filter
         */
        this.SearchFilter = null;
        /**
         * Expand group membership
         */
        this.ExpandGroupMembership = false;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetDiscoverySearchConfigurationResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetSearchableMailboxesResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetSearchableMailboxes;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetSearchableMailboxesResponse_1.GetSearchableMailboxesResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SearchFilter, this.SearchFilter || ExtensionMethods_1.StringHelper.Empty);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ExpandGroupMembership, this.ExpandGroupMembership);
    }
}
exports.GetSearchableMailboxesRequest = GetSearchableMailboxesRequest;
//# sourceMappingURL=GetSearchableMailboxesRequest.js.map