"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserRetentionPolicyTagsRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const GetUserRetentionPolicyTagsResponse_1 = require("../Responses/GetUserRetentionPolicyTagsResponse");
const XmlElementNames_1 = require("../XmlElementNames");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a GetUserRetentionPolicyTagsRequest request.
 *
 * @sealed
 */
class GetUserRetentionPolicyTagsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **GetUserRetentionPolicyTagsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<GetUserRetentionPolicyTagsResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute();
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetUserRetentionPolicyTagsResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.GetUserRetentionPolicyTags;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new GetUserRetentionPolicyTagsResponse_1.GetUserRetentionPolicyTagsResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        // Don't have parameter in request.
    }
}
exports.GetUserRetentionPolicyTagsRequest = GetUserRetentionPolicyTagsRequest;
//# sourceMappingURL=GetUserRetentionPolicyTagsRequest.js.map