"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MoveCopyFolderRequest = void 0;
const FolderIdWrapperList_1 = require("../../Misc/FolderIdWrapperList");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const MoveCopyRequest_1 = require("./MoveCopyRequest");
/** @internal */
class MoveCopyFolderRequest extends MoveCopyRequest_1.MoveCopyRequest {
    constructor(service, errorHandlingMode) {
        super(service, errorHandlingMode);
        this.folderIds = new FolderIdWrapperList_1.FolderIdWrapperList();
    }
    get FolderIds() { return this.folderIds; }
    AddIdsToJson(jsonObject, service) { throw new Error("MoveCopyFolderRequest.ts - AddIdsToJson : Not implemented."); }
    GetExpectedResponseMessageCount() { return this.FolderIds.Count; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateParamCollection(this.FolderIds, "FolderIds");
        this.FolderIds.Validate(this.Service.RequestedServerVersion);
    }
    /**@internal */
    WriteIdsToXml(writer) {
        this.folderIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.FolderIds);
    }
}
exports.MoveCopyFolderRequest = MoveCopyFolderRequest;
//# sourceMappingURL=MoveCopyFolderRequest.js.map