"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResolveNamesRequest = void 0;
const ResolveNameSearchLocation_1 = require("../../Enumerations/ResolveNameSearchLocation");
const PropertySet_1 = require("../PropertySet");
const FolderIdWrapperList_1 = require("../../Misc/FolderIdWrapperList");
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const LazyMember_1 = require("../LazyMember");
const EwsLogging_1 = require("../EwsLogging");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const AltDictionary_1 = require("../../AltDictionary");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const ResolveNamesResponse_1 = require("../Responses/ResolveNamesResponse");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
/** @internal */
class ResolveNamesRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    constructor(service) {
        super(service, ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError);
        this.nameToResolve = null;
        this.returnFullContactData = false;
        this.searchLocation = ResolveNameSearchLocation_1.ResolveNameSearchLocation.DirectoryOnly;
        this.contactDataPropertySet = null;
        this.parentFolderIds = new FolderIdWrapperList_1.FolderIdWrapperList();
    }
    set NameToResolve(value) {
        this.nameToResolve = value;
    }
    get NameToResolve() {
        return this.nameToResolve;
    }
    get ReturnFullContactData() {
        return this.returnFullContactData;
    }
    set ReturnFullContactData(value) {
        this.returnFullContactData = value;
    }
    get SearchLocation() {
        return this.searchLocation;
    }
    set SearchLocation(value) {
        this.searchLocation = value;
    }
    get ContactDataPropertySet() {
        return this.contactDataPropertySet;
    }
    set ContactDataPropertySet(value) {
        this.contactDataPropertySet = value;
    }
    get ParentFolderIds() {
        return this.parentFolderIds;
    }
    CreateServiceResponse(service, responseIndex) { return new ResolveNamesResponse_1.ResolveNamesResponse(service); }
    GetExpectedResponseMessageCount() { return 1; }
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    GetResponseMessageXmlElementName() { return XmlElementNames_1.XmlElementNames.ResolveNamesResponseMessage; }
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.ResolveNamesResponse; }
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.ResolveNames; }
    Validate() {
        super.Validate();
        //EwsUtilities.ValidateNonBlankStringParam(this.NameToResolve, "NameToResolve");
    }
    /**@internal */
    WriteAttributesToXml(writer) {
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.ReturnFullContactData, this.ReturnFullContactData);
        var searchScope = { outValue: null };
        ResolveNamesRequest.searchScopeMap.Member.tryGetValue(this.SearchLocation, searchScope);
        EwsLogging_1.EwsLogging.Assert(!ExtensionMethods_1.StringHelper.IsNullOrEmpty(searchScope.outValue), "ResolveNameRequest.WriteAttributesToXml", "The specified search location cannot be mapped to an EWS search scope.");
        var propertySet = { outValue: null };
        if (this.contactDataPropertySet != null) {
            PropertySet_1.PropertySet.DefaultPropertySetMap.Member.tryGetValue(this.contactDataPropertySet.BasePropertySet, propertySet);
        }
        if (!this.Service.Exchange2007CompatibilityMode) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.SearchScope, searchScope.outValue);
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(propertySet.outValue)) {
            writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.ContactDataShape, propertySet.outValue);
        }
    }
    /**@internal */
    WriteElementsToXml(writer) {
        this.ParentFolderIds.WriteToXml(writer, XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ParentFolderIds);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.UnresolvedEntry, this.NameToResolve);
    }
}
exports.ResolveNamesRequest = ResolveNamesRequest;
ResolveNamesRequest.searchScopeMap = new LazyMember_1.LazyMember(() => {
    var map = new AltDictionary_1.Dictionary((rnsl) => ResolveNameSearchLocation_1.ResolveNameSearchLocation[rnsl]);
    map.Add(ResolveNameSearchLocation_1.ResolveNameSearchLocation.DirectoryOnly, "ActiveDirectory");
    map.Add(ResolveNameSearchLocation_1.ResolveNameSearchLocation.DirectoryThenContacts, "ActiveDirectoryContacts");
    map.Add(ResolveNameSearchLocation_1.ResolveNameSearchLocation.ContactsOnly, "Contacts");
    map.Add(ResolveNameSearchLocation_1.ResolveNameSearchLocation.ContactsThenDirectory, "ContactsActiveDirectory");
    return map;
});
//# sourceMappingURL=ResolveNamesRequest.js.map