"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetHoldOnMailboxesRequest = void 0;
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const HoldAction_1 = require("../../Enumerations/HoldAction");
const ServiceValidationException_1 = require("../../Exceptions/ServiceValidationException");
const SetHoldOnMailboxesResponse_1 = require("../Responses/SetHoldOnMailboxesResponse");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const Strings_1 = require("../../Strings");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a SetHoldOnMailboxesRequest request.
 *
 * @sealed
 */
class SetHoldOnMailboxesRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **SetHoldOnMailboxesRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        /**
         * Action type
         */
        this.ActionType = HoldAction_1.HoldAction.Create;
        /**
         * Hold id
         */
        this.HoldId = null;
        /**
         * Query
         */
        this.Query = null;
        /**
         * Collection of mailboxes to be held/unheld
         */
        this.Mailboxes = null;
        /**
         * Query language
         */
        this.Language = null;
        /**
         * InPlaceHold Identity
         */
        this.InPlaceHoldIdentity = null;
        /**
         * Item hold period
         * *The text value can be "Unlimited" or the string value of any Timespan value.*
         */
        this.ItemHoldPeriod = null;
        /**
         * Include Non Indexable Items
         */
        this.IncludeNonIndexableItems = null;
        /**
         * Perform deduplication
         */
        this.PerformDeduplication = null;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {Promise<SetHoldOnMailboxesResponse>}      Service response  :Promise.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.SetHoldOnMailboxesResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.SetHoldOnMailboxes;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        let response = new SetHoldOnMailboxesResponse_1.SetHoldOnMailboxesResponse();
        response.LoadFromXmlJsObject(jsonBody, this.Service);
        return response;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.HoldId)) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.HoldIdParameterIsNotSpecified);
        }
        if (ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.InPlaceHoldIdentity) && (this.Mailboxes == null || this.Mailboxes.length == 0)) {
            throw new ServiceValidationException_1.ServiceValidationException(Strings_1.Strings.HoldMailboxesParameterIsNotSpecified);
        }
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ActionType, HoldAction_1.HoldAction[this.ActionType]);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.HoldId, this.HoldId);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Query, this.Query || ExtensionMethods_1.StringHelper.Empty);
        if (this.Mailboxes != null && this.Mailboxes.length > 0) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Mailboxes);
            for (let mailbox of this.Mailboxes) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.String, mailbox);
            }
            writer.WriteEndElement(); // Mailboxes
        }
        // Language
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.Language)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Language, this.Language);
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.InPlaceHoldIdentity)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.InPlaceHoldIdentity, this.InPlaceHoldIdentity);
        }
        /** per github issue #120 */
        if (this.IncludeNonIndexableItems !== null) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.IncludeNonIndexableItems, this.IncludeNonIndexableItems);
        }
        /** per github issue #120 */
        if (this.PerformDeduplication !== null) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.Deduplication, this.PerformDeduplication);
        }
        if (!ExtensionMethods_1.StringHelper.IsNullOrEmpty(this.ItemHoldPeriod)) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.ItemHoldPeriod, this.ItemHoldPeriod);
        }
    }
}
exports.SetHoldOnMailboxesRequest = SetHoldOnMailboxesRequest;
//# sourceMappingURL=SetHoldOnMailboxesRequest.js.map