"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetTeamMailboxRequest = void 0;
const ArgumentException_1 = require("../../Exceptions/ArgumentException");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const TeamMailboxLifecycleState_1 = require("../../Enumerations/TeamMailboxLifecycleState");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a SetTeamMailbox request.
 *
 * @sealed
 */
class SetTeamMailboxRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **SetTeamMailboxRequest** class.
     *
     * @param   {ExchangeService}               service             The service
     * @param   {EmailAddress}                  emailAddress        TeamMailbox email address
     * @param   {Uri}                           sharePointSiteUrl   SharePoint site URL
     * @param   {TeamMailboxLifecycleState}     state               TeamMailbox state
     */
    constructor(service, emailAddress, sharePointSiteUrl, state) {
        super(service);
        /**
         * TeamMailbox email address
         */
        this.emailAddress = null;
        /**
         * SharePoint site URL
         */
        this.sharePointSiteUrl = null;
        /**
         * TeamMailbox lifecycle state
         */
        this.state = TeamMailboxLifecycleState_1.TeamMailboxLifecycleState.Active;
        if (emailAddress === null) {
            throw new ArgumentException_1.ArgumentNullException("emailAddress");
        }
        if (sharePointSiteUrl === null) {
            throw new ArgumentException_1.ArgumentNullException("sharePointSiteUrl");
        }
        this.emailAddress = emailAddress;
        this.sharePointSiteUrl = sharePointSiteUrl;
        this.state = state;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {ServiceResponse}      Service response.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2013;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name,
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.SetTeamMailboxResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name,
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.SetTeamMailbox;
    }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsonBody   The js object response body.
     * @return  {any}              Response object.
     */
    ParseResponse(jsonBody) {
        var serviceResponse = new ServiceResponse_1.ServiceResponse();
        serviceResponse.LoadFromXmlJsObject(jsonBody, this.Service);
        return serviceResponse;
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        //this.emailAddress.WriteToXml(writer, XmlNamespace.Messages, XmlElementNames.EmailAddress);
        this.emailAddress.WriteToXml(writer, XmlElementNames_1.XmlElementNames.EmailAddress, XmlNamespace_1.XmlNamespace.Messages);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SharePointSiteUrl, this.sharePointSiteUrl.ToString());
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.State, TeamMailboxLifecycleState_1.TeamMailboxLifecycleState[this.state]);
    }
}
exports.SetTeamMailboxRequest = SetTeamMailboxRequest;
//# sourceMappingURL=SetTeamMailboxRequest.js.map