"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SetUserOofSettingsRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ServiceResponse_1 = require("../Responses/ServiceResponse");
const SimpleServiceRequestBase_1 = require("./SimpleServiceRequestBase");
/**
 * @internal Represents a SetUserOofSettings request.
 *
 * @sealed
 */
class SetUserOofSettingsRequest extends SimpleServiceRequestBase_1.SimpleServiceRequestBase {
    /**
     * @internal Initializes a new instance of the **SetUserOofSettingsRequest** class.
     *
     * @param   {ExchangeService}   service   The service.
     */
    constructor(service) {
        super(service);
        this.smtpAddress = null;
        this.oofSettings = null;
    }
    /**
     * Gets or sets the SMTP address.
     */
    get SmtpAddress() {
        return this.smtpAddress;
    }
    set SmtpAddress(value) {
        this.smtpAddress = value;
    }
    /**
     * Gets or sets the oof settings.
     */
    get OofSettings() {
        return this.oofSettings;
    }
    set OofSettings(value) {
        this.oofSettings = value;
    }
    /**
     * @internal Executes this request.
     *
     * @return  {ServiceResponse}      Service response.
     */
    Execute() {
        return this.InternalExecute().then((serviceResponse) => {
            serviceResponse.ThrowIfNecessary();
            return serviceResponse;
        });
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() { return XmlElementNames_1.XmlElementNames.SetUserOofSettingsResponse; }
    /**
     * Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.SetUserOofSettingsRequest; }
    /**
     * @internal Parses the response.
     *
     * @param   {any}   jsObjectBody   The jsObjectBody from XmlJsObject.
     * @return  {any}            Service response.
     */
    ParseResponse(jsObjectBody) {
        var serviceResponse = new ServiceResponse_1.ServiceResponse();
        serviceResponse.LoadFromXmlJsObject(jsObjectBody[XmlElementNames_1.XmlElementNames.ResponseMessage], this.Service);
        return serviceResponse;
    }
    /**
     * @internal Validate request..
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.SmtpAddress, "SmtpAddress");
        EwsUtilities_1.EwsUtilities.ValidateParam(this.OofSettings, "OofSettings");
    }
    /**
     * @internal Writes the elements to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Mailbox);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Address, this.SmtpAddress);
        writer.WriteEndElement(); // Mailbox
        this.OofSettings.WriteToXml(writer, XmlElementNames_1.XmlElementNames.UserOofSettings);
    }
}
exports.SetUserOofSettingsRequest = SetUserOofSettingsRequest;
//# sourceMappingURL=SetUserOofSettingsRequest.js.map