"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SyncFolderHierarchyRequest = void 0;
const EwsUtilities_1 = require("../EwsUtilities");
const ExchangeVersion_1 = require("../../Enumerations/ExchangeVersion");
const ServiceErrorHandling_1 = require("../../Enumerations/ServiceErrorHandling");
const ServiceObjectType_1 = require("../../Enumerations/ServiceObjectType");
const XmlElementNames_1 = require("../XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const MultiResponseServiceRequest_1 = require("./MultiResponseServiceRequest");
const SyncFolderHierarchyResponse_1 = require("../Responses/SyncFolderHierarchyResponse");
/**
 * @internal Represents a SyncFolderHierarchy request.
 */
class SyncFolderHierarchyRequest extends MultiResponseServiceRequest_1.MultiResponseServiceRequest {
    /**
     * @internal Initializes a new instance of the **SyncFolderItemsRequest** class.
     *
     * @param   {ExchangeService}   	service             The service.
     */
    constructor(service) {
        super(service, ServiceErrorHandling_1.ServiceErrorHandling.ThrowOnError);
        this.propertySet = null;
        this.syncFolderId = null;
        this.syncState = null;
    }
    /**
     * Gets or sets the property set.
     *
     * @value	The property set
     */
    get PropertySet() {
        return this.propertySet;
    }
    set PropertySet(value) {
        this.propertySet = value;
    }
    /**
     * Gets or sets the sync folder id.
     *
     * @value	The sync folder id.
     */
    get SyncFolderId() {
        return this.syncFolderId;
    }
    set SyncFolderId(value) {
        this.syncFolderId = value;
    }
    /**
     * Gets or sets the state of the sync.
     *
     * @value	The state of the sync.
     */
    get SyncState() {
        return this.syncState;
    }
    set SyncState(value) {
        this.syncState = value;
    }
    /**
     * @internal Creates the service response.
     *
     * @param   {ExchangeService}   service         The service.
     * @param   {number}   			responseIndex   Index of the response.
     * @return  {SyncFolderItemsResponse}		Response object.
     */
    CreateServiceResponse(service, responseIndex) {
        return new SyncFolderHierarchyResponse_1.SyncFolderHierarchyResponse(this.PropertySet);
    }
    /**
     * @internal Gets the expected response message count.
     *
     * @return  {number}      Number of items in response.
     */
    GetExpectedResponseMessageCount() {
        return 1;
    }
    /**
     * @internal Gets the request version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this request is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Gets the name of the response message XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseMessageXmlElementName() {
        return XmlElementNames_1.XmlElementNames.SyncFolderHierarchyResponseMessage;
    }
    /**
     * @internal Gets the name of the response XML element.
     *
     * @return  {string}      XML element name.
     */
    GetResponseXmlElementName() {
        return XmlElementNames_1.XmlElementNames.SyncFolderHierarchyResponse;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.SyncFolderHierarchy;
    }
    /**
     * @internal Validate request.
     */
    Validate() {
        super.Validate();
        EwsUtilities_1.EwsUtilities.ValidateParam(this.PropertySet, "PropertySet");
        if (this.SyncFolderId != null) {
            this.SyncFolderId.Validate(this.Service.RequestedServerVersion);
        }
        this.PropertySet.ValidateForRequest(this, false /*summaryPropertiesOnly*/);
    }
    /**
     * @internal Writes the elements to XML writer.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteElementsToXml(writer) {
        this.PropertySet.WriteToXml(writer, ServiceObjectType_1.ServiceObjectType.Folder);
        if (this.SyncFolderId != null) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SyncFolderId);
            this.SyncFolderId.WriteToXml(writer);
            writer.WriteEndElement();
        }
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Messages, XmlElementNames_1.XmlElementNames.SyncState, this.SyncState);
    }
}
exports.SyncFolderHierarchyRequest = SyncFolderHierarchyRequest;
//# sourceMappingURL=SyncFolderHierarchyRequest.js.map