"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeleteAttachmentResponse = void 0;
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
const EwsLogging_1 = require("../EwsLogging");
const ExtensionMethods_1 = require("../../ExtensionMethods");
/**
 * Represents the response to an individual attachment deletion operation.
 * @sealed
 */
class DeleteAttachmentResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * Initializes a new instance of the **DeleteAttachmentResponse** class.
     *
     * @param   {Attachment}   attachment   The attachment.
     */
    constructor(attachment) {
        super();
        this.attachment = null;
        EwsLogging_1.EwsLogging.Assert(attachment != null, "CreateAttachmentResponse.ctor", "attachment is null");
        this.attachment = attachment;
    }
    /**
     * Gets the attachment that was deleted.
     */
    get Attachment() {
        return this.attachment;
    }
    /**
      * @internal Reads response elements from Xml JsObject.
      *
      * @param   {any}               jsObject   The response object.
      * @param   {ExchangeService}   service    The service.
      */
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.RootItemId]) {
            let jsRootItemId = responseObject[XmlElementNames_1.XmlElementNames.RootItemId];
            let changeKey;
            if (jsRootItemId[XmlAttributeNames_1.XmlAttributeNames.RootItemChangeKey] &&
                !ExtensionMethods_1.StringHelper.IsNullOrEmpty(changeKey = jsRootItemId[XmlAttributeNames_1.XmlAttributeNames.RootItemChangeKey]) &&
                this.attachment.Owner != null) {
                this.attachment.Owner.RootItemId.ChangeKey = changeKey;
            }
        }
    }
}
exports.DeleteAttachmentResponse = DeleteAttachmentResponse;
//# sourceMappingURL=DeleteAttachmentResponse.js.map