"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FindItemResponse = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const XmlAttributeNames_1 = require("../XmlAttributeNames");
const ItemGroup_1 = require("../../Search/ItemGroup");
const HighlightTerm_1 = require("../../ComplexProperties/HighlightTerm");
const ItemInfo_1 = require("../ServiceObjects/Items/ItemInfo");
const GroupedFindItemsResults_1 = require("../../Search/GroupedFindItemsResults");
const FindItemsResults_1 = require("../../Search/FindItemsResults");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const EwsLogging_1 = require("../EwsLogging");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const ServiceResponse_1 = require("./ServiceResponse");
class FindItemResponse extends ServiceResponse_1.ServiceResponse {
    constructor(isGrouped, propertySet) {
        super();
        this.isGrouped = false;
        this.isGrouped = isGrouped;
        this.propertySet = propertySet;
        EwsLogging_1.EwsLogging.Assert(this.propertySet != null, "FindItemResponse.ctor", "PropertySet should not be null");
    }
    get GroupedFindResults() { return this.groupedFindResults; }
    get Results() { return this.results; }
    CreateItemInstance(service, xmlElementName) {
        var itemInfo = new ItemInfo_1.ItemInfo();
        return itemInfo.CreateEwsObjectFromXmlElementName(service, xmlElementName);
        //return EwsUtilities.CreateEwsObjectFromXmlElementName<TItem>(service, xmlElementName);
    }
    InternalReadItemsFromJson(jsonObject /*JsonObject*/, propertySet, service, destinationList /*System.Collections.Generic.IList<TItem>*/) { throw new Error("FindItemResponse.ts - InternalReadItemsFromJson : Not implemented."); }
    InternalReadItemsFromXmlJsObject(jsonObject, propertySet, service, destinationList /*System.Collections.Generic.IList<TItem>*/) {
        EwsLogging_1.EwsLogging.Assert(destinationList != null, "FindItemResponse.InternalReadItemsFromJson", "destinationList is null.");
        if (jsonObject[XmlElementNames_1.XmlElementNames.Items]) {
            var items = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(jsonObject, service, XmlElementNames_1.XmlElementNames.Items, this.CreateItemInstance, true, /* clearPropertyBag */ this.propertySet, /* requestedPropertySet */ true); /* summaryPropertiesOnly */
            items.forEach((item, index) => { destinationList.push(item); });
        }
    }
    ReadElementsFromJson(responseObject /*JsonObject*/, service) { throw new Error("FindItemResponse.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        var rootFolder = responseObject[XmlElementNames_1.XmlElementNames.RootFolder];
        var totalItemsInView = Number(rootFolder[XmlAttributeNames_1.XmlAttributeNames.TotalItemsInView]);
        var moreItemsAvailable = !ExtensionMethods_1.Convert.toBool(rootFolder[XmlAttributeNames_1.XmlAttributeNames.IncludesLastItemInRange]);
        // Ignore IndexedPagingOffset attribute if moreItemsAvailable is false.
        var nextPageOffset = null;
        if (moreItemsAvailable) {
            if (rootFolder[XmlAttributeNames_1.XmlAttributeNames.IndexedPagingOffset]) {
                nextPageOffset = Number(rootFolder[XmlAttributeNames_1.XmlAttributeNames.IndexedPagingOffset]);
            }
        }
        if (!this.isGrouped) {
            this.results = new FindItemsResults_1.FindItemsResults();
            this.results.TotalCount = totalItemsInView;
            this.results.NextPageOffset = nextPageOffset;
            this.results.MoreAvailable = moreItemsAvailable;
            this.InternalReadItemsFromXmlJsObject(rootFolder, this.propertySet, service, this.results.Items);
        }
        else {
            this.groupedFindResults = new GroupedFindItemsResults_1.GroupedFindItemsResults();
            this.groupedFindResults.TotalCount = totalItemsInView;
            this.groupedFindResults.NextPageOffset = nextPageOffset;
            this.groupedFindResults.MoreAvailable = moreItemsAvailable;
            if (rootFolder[XmlElementNames_1.XmlElementNames.Groups]) {
                var jsGroups = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(rootFolder, XmlElementNames_1.XmlElementNames.Groups);
                for (var jsGroup of jsGroups) //jsGroups.OfType<JsonObject>()
                 {
                    if (jsGroup[XmlElementNames_1.XmlElementNames.GroupedItems]) {
                        var jsGroupedItemCollection = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(jsGroup, XmlElementNames_1.XmlElementNames.GroupedItems);
                        for (var jsGroupedItem of jsGroupedItemCollection) {
                            var groupIndex = jsGroupedItem[XmlElementNames_1.XmlElementNames.GroupIndex];
                            var itemList = []; // new List<TItem>();
                            this.InternalReadItemsFromXmlJsObject(jsGroupedItem, this.propertySet, service, itemList);
                            this.groupedFindResults.ItemGroups.push(new ItemGroup_1.ItemGroup(groupIndex, itemList));
                        }
                    }
                }
            }
        }
        //debug: //ref: need to find example.
        //todo: check highlight terms and grouping.
        if (responseObject[XmlElementNames_1.XmlElementNames.HighlightTerms]) {
            var highlightTermElements = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject, XmlElementNames_1.XmlElementNames.HighlightTerms);
            for (var highlightTermElement of highlightTermElements) {
                if (highlightTermElement[XmlElementNames_1.XmlElementNames.HighlightTerm]) {
                    var highlightTermObjects = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(highlightTermElement, XmlElementNames_1.XmlElementNames.HighlightTerm);
                    for (var jsonHighlightTerm of highlightTermObjects) {
                        var term = new HighlightTerm_1.HighlightTerm();
                        term.LoadFromXmlJsObject(jsonHighlightTerm, service);
                        this.results.HighlightTerms.push(term);
                    }
                }
            }
        }
    }
}
exports.FindItemResponse = FindItemResponse;
//# sourceMappingURL=FindItemResponse.js.map