"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetAppMarketplaceUrlResponse = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal  Represents the response to a GetAppMarketplaceUrl operation
 *
 * @sealed
 */
class GetAppMarketplaceUrlResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetAppMarketplaceUrlResponse** class.
     */
    constructor() {
        super();
    }
    /**
     * App Marketplace Url
     */
    get AppMarketplaceUrl() {
        return this.appMarketplaceUrl;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        this.appMarketplaceUrl = jsObject[XmlElementNames_1.XmlElementNames.AppMarketplaceUrl];
    }
}
exports.GetAppMarketplaceUrlResponse = GetAppMarketplaceUrlResponse;
//# sourceMappingURL=GetAppMarketplaceUrlResponse.js.map