"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetEventsResponse = void 0;
const GetEventsResults_1 = require("../../Notifications/GetEventsResults");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the response to a subscription event retrieval operation.
 *
 * @sealed
 */
class GetEventsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetEventsResponse** class.
     */
    constructor() {
        super();
        this.results = new GetEventsResults_1.GetEventsResults();
    }
    /**
     * @internal Gets event results from subscription.
     */
    get Results() {
        return this.results;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(jsObject, service) {
        this.results.LoadFromXmlJsObject(jsObject, service);
    }
}
exports.GetEventsResponse = GetEventsResponse;
//# sourceMappingURL=GetEventsResponse.js.map