"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetFolderResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const FolderInfo_1 = require("../ServiceObjects/Folders/FolderInfo");
const EwsLogging_1 = require("../EwsLogging");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
class GetFolderResponse extends ServiceResponse_1.ServiceResponse {
    constructor(folder, propertySet) {
        super();
        this.folder = folder;
        this.propertySet = propertySet;
        EwsLogging_1.EwsLogging.Assert(this.propertySet != null, "GetFolderResponse.ctor", "PropertySet should not be null");
    }
    get Folder() { return this.folder; }
    GetObjectInstance(service, xmlElementName) {
        if (this.Folder != null) {
            return this.Folder;
        }
        else {
            var flinfo = new FolderInfo_1.FolderInfo();
            return flinfo.CreateEwsObjectFromXmlElementName(service, xmlElementName);
        }
    }
    ReadElementsFromXmlJsObject(responseObject, service) {
        if (responseObject[XmlElementNames_1.XmlElementNames.Folders]) {
            var folders = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Folders, this.GetObjectInstance.bind(this), true, /* clearPropertyBag */ this.propertySet, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
            this.folder = folders[0];
        }
    }
}
exports.GetFolderResponse = GetFolderResponse;
//# sourceMappingURL=GetFolderResponse.js.map