"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetItemResponse = void 0;
const ItemInfo_1 = require("../ServiceObjects/Items/ItemInfo");
const EwsLogging_1 = require("../EwsLogging");
const XmlElementNames_1 = require("../XmlElementNames");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const ServiceResponse_1 = require("./ServiceResponse");
class GetItemResponse extends ServiceResponse_1.ServiceResponse {
    constructor(item, propertySet) {
        super();
        this.item = null;
        this.propertySet = null;
        this.item = item;
        this.propertySet = propertySet;
        EwsLogging_1.EwsLogging.Assert(this.propertySet !== null, "GetItemResponse.ctor", "PropertySet should not be null");
    }
    get Item() {
        return this.item;
    }
    GetObjectInstance(service, xmlElementName) {
        if (this.Item != null) {
            return this.Item;
        }
        else {
            return new ItemInfo_1.ItemInfo().CreateEwsObjectFromXmlElementName(service, xmlElementName);
        }
    }
    //ReadElementsFromJson(responseObject: any, service: ExchangeService): any { throw new Error("GetItemResponse.ts - ReadElementsFromJson : Not implemented."); }
    ReadElementsFromXmlJsObject(responseObject, service) {
        var items = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Items, (s, e) => { return this.GetObjectInstance(s, e); }, true, /* clearPropertyBag         */ this.propertySet, /* requestedPropertySet     */ false); /* summaryPropertiesOnly    */
        this.item = items[0];
    }
}
exports.GetItemResponse = GetItemResponse;
//# sourceMappingURL=GetItemResponse.js.map