"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GetUserRetentionPolicyTagsResponse = void 0;
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const RetentionPolicyTag_1 = require("../../Elc/RetentionPolicyTag");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * Represents the GetUserRetentionPolicyTagsResponse response.
 *
 * @sealed
 */
class GetUserRetentionPolicyTagsResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **GetUserRetentionPolicyTagsResponse** class.
     */
    constructor() {
        super();
        this.retentionPolicyTags = [];
    }
    /**
     * Retention policy tags result.
     */
    get RetentionPolicyTags() {
        return this.retentionPolicyTags;
    }
    /**
     * @internal Reads response elements from Xml JsObject.
     *
     * @param   {any}               jsObject   The response object.
     * @param   {ExchangeService}   service    The service.
     */
    ReadElementsFromXmlJsObject(responseObject, service) {
        this.retentionPolicyTags.splice(0);
        if (responseObject[XmlElementNames_1.XmlElementNames.RetentionPolicyTags]) {
            for (let retentionPolicyTagObject of EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(responseObject[XmlElementNames_1.XmlElementNames.RetentionPolicyTags], XmlElementNames_1.XmlElementNames.RetentionPolicyTag)) {
                this.retentionPolicyTags.push(RetentionPolicyTag_1.RetentionPolicyTag.LoadFromXmlJsObject(retentionPolicyTagObject));
            }
        }
    }
}
exports.GetUserRetentionPolicyTagsResponse = GetUserRetentionPolicyTagsResponse;
//# sourceMappingURL=GetUserRetentionPolicyTagsResponse.js.map