"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SuggestionsResponse = void 0;
const XmlElementNames_1 = require("../XmlElementNames");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const Suggestion_1 = require("../../ComplexProperties/Availability/Suggestion");
const ServiceResponse_1 = require("./ServiceResponse");
class SuggestionsResponse extends ServiceResponse_1.ServiceResponse {
    constructor() {
        super(...arguments);
        this.daySuggestions = []; //System.Collections.ObjectModel.Collection<Suggestion>;
    }
    get Suggestions() { return this.daySuggestions; } //System.Collections.ObjectModel.Collection<Suggestion>;
    LoadSuggestedDaysFromXml(jsonProperty, service) {
        var SuggestionArrayObj = jsonProperty[XmlElementNames_1.XmlElementNames.SuggestionDayResultArray];
        if (typeof SuggestionArrayObj === 'undefined')
            throw new Error("SuggestionsResponse.ts - LoadSuggestedDaysFromXml - invalid object returned ");
        var suggestions = EwsServiceJsonReader_1.EwsServiceJsonReader.ReadAsArray(SuggestionArrayObj, XmlElementNames_1.XmlElementNames.SuggestionDayResult);
        for (var suggestion of suggestions) {
            var daySuggestion = new Suggestion_1.Suggestion();
            daySuggestion.LoadFromXmlJsObject(suggestion, service);
            this.daySuggestions.push(daySuggestion);
        }
    }
}
exports.SuggestionsResponse = SuggestionsResponse;
//# sourceMappingURL=SuggestionsResponse.js.map