"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateInboxRulesResponse = void 0;
const RuleOperationErrorCollection_1 = require("../../ComplexProperties/RuleOperationErrorCollection");
const XmlElementNames_1 = require("../XmlElementNames");
const ServiceResponse_1 = require("./ServiceResponse");
/**
 * @internal Represents the response to a UpdateInboxRulesResponse operation.
 *
 * @sealed
 */
class UpdateInboxRulesResponse extends ServiceResponse_1.ServiceResponse {
    /**
     * @internal Initializes a new instance of the **UpdateInboxRulesResponse** class.
     */
    constructor() {
        super();
        /**
         * Rule operation error collection.
         */
        this.errors = null;
        this.errors = new RuleOperationErrorCollection_1.RuleOperationErrorCollection();
    }
    /**
     * @internal Gets the rule operation errors in the response.
     */
    get Errors() {
        return this.errors;
    }
    /**
     * @internal Loads extra error details from XML
     *
     * @param   {any}   			responseObject      Json Object converted from XML.
     * @param   {ExchangeService}   service             The service.
     */
    LoadExtraErrorDetailsFromXmlJsObject(responseObject, service) {
        super.LoadExtraErrorDetailsFromXmlJsObject(responseObject, service);
        if (responseObject[XmlElementNames_1.XmlElementNames.RuleOperationErrors]) {
            this.errors.CreateFromXmlJsObjectCollection(responseObject[XmlElementNames_1.XmlElementNames.RuleOperationErrors][XmlElementNames_1.XmlElementNames.RuleOperationError], service);
        }
    }
}
exports.UpdateInboxRulesResponse = UpdateInboxRulesResponse;
//# sourceMappingURL=UpdateInboxRulesResponse.js.map