"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateItemResponse = void 0;
const ServiceResult_1 = require("../../Enumerations/ServiceResult");
const ItemInfo_1 = require("../ServiceObjects/Items/ItemInfo");
const EwsServiceJsonReader_1 = require("../EwsServiceJsonReader");
const XmlElementNames_1 = require("../XmlElementNames");
const ExtensionMethods_1 = require("../../ExtensionMethods");
const EwsLogging_1 = require("../EwsLogging");
const ServiceResponse_1 = require("./ServiceResponse");
class UpdateItemResponse extends ServiceResponse_1.ServiceResponse {
    constructor(item) {
        super();
        this.item = null;
        this.returnedItem = null;
        this.conflictCount = 0;
        EwsLogging_1.EwsLogging.Assert(item != null, "UpdateItemResponse.ctor", "item is null");
        this.item = item;
    }
    get ReturnedItem() {
        return this.returnedItem;
    }
    get ConflictCount() {
        return this.conflictCount;
    }
    GetObjectInstance(service, xmlElementName) {
        this.returnedItem = new ItemInfo_1.ItemInfo().CreateEwsObjectFromXmlElementName(service, xmlElementName);
        return this.returnedItem;
    }
    Loaded() {
        if (this.Result == ServiceResult_1.ServiceResult.Success) {
            this.item.ClearChangeLog();
        }
    }
    ReadElementsFromXmlJsObject(responseObject, service) {
        EwsServiceJsonReader_1.EwsServiceJsonReader.ReadServiceObjectsCollectionFromJson(responseObject, service, XmlElementNames_1.XmlElementNames.Items, this.GetObjectInstance.bind(this), false, /* clearPropertyBag */ null, /* requestedPropertySet */ false); /* summaryPropertiesOnly */
        // ConflictResults was only added in 2007 SP1 so if this was a 2007 RTM request we shouldn't expect to find the element
        if (!service.Exchange2007CompatibilityMode) {
            this.conflictCount = ExtensionMethods_1.Convert.toNumber(responseObject[XmlElementNames_1.XmlElementNames.ConflictResults][XmlElementNames_1.XmlElementNames.Count]);
        }
        // If UpdateItem returned an item that has the same Id as the item that
        // is being updated, this is a "normal" UpdateItem operation, and we need
        // to update the ChangeKey of the item being updated with the one that was
        // returned. Also set returnedItem to indicate that no new item was returned.
        //
        // Otherwise, this in a "special" UpdateItem operation, such as a recurring
        // task marked as complete (the returned item in that case is the one-off
        // task that represents the completed instance).
        //
        // Note that there can be no returned item at all, as in an UpdateItem call
        // with MessageDisposition set to SendOnly or SendAndSaveCopy.
        if (this.returnedItem != null) {
            if (this.item.Id.UniqueId == this.returnedItem.Id.UniqueId) {
                this.item.Id.ChangeKey = this.returnedItem.Id.ChangeKey;
                this.returnedItem = null;
            }
        }
    }
}
exports.UpdateItemResponse = UpdateItemResponse;
//# sourceMappingURL=UpdateItemResponse.js.map