"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FolderInfo = void 0;
const XmlElementNames_1 = require("../../XmlElementNames");
const CalendarFolder_1 = require("./CalendarFolder");
const ContactsFolder_1 = require("./ContactsFolder");
const Folder_1 = require("./Folder");
const SearchFolder_1 = require("./SearchFolder");
const TasksFolder_1 = require("./TasksFolder");
const ServiceObjectInfo_1 = require("../ServiceObjectInfo");
/**
 * this is partial section of CreateEwsObjectFromXmlElementName from serviceobjectinfo, other parts are moved to different object type like itemInfo etc.
 * this to is to avoid circular referencing with requirejs/commonjs/nodejs
 */
class FolderInfo extends ServiceObjectInfo_1.ServiceObjectInfo {
    InitializeServiceObjectClassMap() {
        // CalendarFolder
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.CalendarFolder, "CalendarFolder", (srv) => { return new CalendarFolder_1.CalendarFolder(srv); }, null);
        // ContactsFolder
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.ContactsFolder, "ContactsFolder", (srv) => { return new ContactsFolder_1.ContactsFolder(srv); }, null);
        // Folder
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.Folder, "Folder", (srv) => { return new Folder_1.Folder(srv); }, null);
        // SearchFolder
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.SearchFolder, "SearchFolder", (srv) => { return new SearchFolder_1.SearchFolder(srv); }, null);
        // TasksFolder
        this.AddServiceObjectType(XmlElementNames_1.XmlElementNames.TasksFolder, "TasksFolder", (srv) => { return new TasksFolder_1.TasksFolder(srv); }, null);
    }
    CreateEwsObjectFromXmlElementName(service, xmlElementName) {
        //var itemClass = this.XmlElementNameToServiceObjectClassMap[xmlElementName];
        //if (itemClass) {
        //    return new itemClass(service);
        //no need of itemclass due to lack of type conversion and dictionary implementation in javascript
        var creationDelegate = this.ServiceObjectConstructorsWithServiceParam[xmlElementName];
        if (creationDelegate) {
            return creationDelegate(service);
        }
        else
            return null;
    }
}
exports.FolderInfo = FolderInfo;
//# sourceMappingURL=FolderInfo.js.map