"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchFolder = void 0;
const EwsLogging_1 = require("../../EwsLogging");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const FolderId_1 = require("../../../ComplexProperties/FolderId");
const PropertySet_1 = require("../../PropertySet");
const Schemas_1 = require("../Schemas/Schemas");
const TypeContainer_1 = require("../../../TypeContainer");
const XmlElementNames_1 = require("../../XmlElementNames");
const Folder_1 = require("./Folder");
/**
 * Represents a search folder.
 */
class SearchFolder extends Folder_1.Folder {
    /**
     * Gets the search parameters associated with the search folder.
     */
    get SearchParameters() { return this.PropertyBag._getItem(Schemas_1.Schemas.SearchFolderSchema.SearchParameters); }
    /**
     * Initializes an unsaved local instance of **SearchFolder**. To bind to an existing contacts folder, use SearchFolder.Bind() instead.
     *
     * @param   {ExchangeService}   service   The ExchangeService object to which the contacts folder will be bound.
     */
    constructor(service) {
        super(service);
    }
    static Bind(service, idOrName, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        if (idOrName instanceof FolderId_1.FolderId) {
            return service.BindToFolder(idOrName, propertySet, TypeContainer_1.TypeContainer.SearchFolder);
        }
        else if (typeof idOrName === 'number') {
            return service.BindToFolder(new FolderId_1.FolderId(idOrName), propertySet, TypeContainer_1.TypeContainer.SearchFolder);
        }
        EwsLogging_1.EwsLogging.Assert(false, "SearchFolder.Bind", "unknown paramete type");
        throw new Error("unknow parameter type. this should not be  reached");
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() { return Schemas_1.Schemas.SearchFolderSchema.Instance; }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.SearchFolder; }
    /**
     * @internal Validates this instance.
     */
    Validate() {
        super.Validate();
        if (this.SearchParameters != null) {
            this.SearchParameters.Validate();
        }
    }
}
exports.SearchFolder = SearchFolder;
//# sourceMappingURL=SearchFolder.js.map