"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Contact = void 0;
const EwsUtilities_1 = require("../../EwsUtilities");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const FileAsMapping_1 = require("../../../Enumerations/FileAsMapping");
const ItemAttachment_1 = require("../../../ComplexProperties/ItemAttachment");
const PropertyException_1 = require("../../../Exceptions/PropertyException");
const PropertySet_1 = require("../../PropertySet");
const Schemas_1 = require("../Schemas/Schemas");
const Strings_1 = require("../../../Strings");
const XmlElementNames_1 = require("../../XmlElementNames");
const Item_1 = require("./Item");
/**
 * Represents a **contact**. Properties available on contacts are defined in the *ContactSchema* class.
 *
 */
class Contact extends Item_1.Item {
    constructor(serviceOrParentAttachment) {
        super(serviceOrParentAttachment instanceof ItemAttachment_1.ItemAttachment ? serviceOrParentAttachment.Service : serviceOrParentAttachment); //todo:fix -can not user instanceof with exchangeservice, creates circular loop with ewsutility 
    }
    /** required to check [Attachable] attribute, AttachmentCollection.AddItemAttachment<TItem>() checks for non inherited [Attachable] attribute. */
    static get Attachable() { return this.name === "Contact"; }
    ;
    /**
     * Gets or set the name under which this contact is filed as. FileAs can be manually set or can be automatically calculated based on the value of the FileAsMapping property.
     *
     */
    get FileAs() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.FileAs);
    }
    set FileAs(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.FileAs, value);
    }
    /**
     * Gets or sets a value indicating how the FileAs property should be automatically calculated.
     *
     */
    get FileAsMapping() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.FileAsMapping);
    }
    set FileAsMapping(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.FileAsMapping, value);
    }
    /**
     * Gets or sets the display name of the contact.
     *
     */
    get DisplayName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.DisplayName);
    }
    set DisplayName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.DisplayName, value);
    }
    /**
     * Gets or sets the given name of the contact.
     *
     */
    get GivenName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.GivenName);
    }
    set GivenName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.GivenName, value);
    }
    /**
     * Gets or sets the initials of the contact.
     *
     */
    get Initials() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Initials);
    }
    set Initials(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Initials, value);
    }
    /**
     * Gets or sets the middle mame of the contact.
     *
     */
    get MiddleName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.MiddleName);
    }
    set MiddleName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.MiddleName, value);
    }
    /**
     * Gets or sets the nick name of the contact.
     *
     */
    get NickName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.NickName);
    }
    set NickName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.NickName, value);
    }
    /**
     * Gets the complete name of the contact.
     *
     */
    get CompleteName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.CompleteName);
    }
    /**
     * Gets or sets the compnay name of the contact.
     *
     */
    get CompanyName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.CompanyName);
    }
    set CompanyName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.CompanyName, value);
    }
    /**
     * Gets an indexed list of e-mail addresses for the contact. For example, to set the first e-mail address,
     * use the following syntax: EmailAddresses[EmailAddressKey.EmailAddress1] = "john.doe@contoso.com"
     *
     */
    get EmailAddresses() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.EmailAddresses);
    }
    /**
     * Gets an indexed list of physical addresses for the contact. For example, to set the business address,
     * use the following syntax: PhysicalAddresses[PhysicalAddressKey.Business] = new PhysicalAddressEntry()
     *
     */
    get PhysicalAddresses() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.PhysicalAddresses);
    }
    /**
     * Gets an indexed list of phone numbers for the contact. For example, to set the home phone number,
     * use the following syntax: PhoneNumbers[PhoneNumberKey.HomePhone] = "phone number"
     *
     */
    get PhoneNumbers() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.PhoneNumbers);
    }
    /**
     * Gets or sets the contact's assistant name.
     *
     */
    get AssistantName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.AssistantName);
    }
    set AssistantName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.AssistantName, value);
    }
    /**
     * Gets or sets the birthday of the contact.
     *
     */
    get Birthday() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Birthday);
    }
    set Birthday(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Birthday, value);
    }
    /**
     * Gets or sets the business home page of the contact.
     *
     */
    get BusinessHomePage() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.BusinessHomePage);
    }
    set BusinessHomePage(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.BusinessHomePage, value);
    }
    /**
     * Gets or sets a list of children for the contact.
     *
     */
    get Children() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Children);
    }
    set Children(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Children, value);
    }
    /**
     * Gets or sets a list of companies for the contact.
     *
     */
    get Companies() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Companies);
    }
    set Companies(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Companies, value);
    }
    /**
     * Gets the source of the contact.
     *
     */
    get ContactSource() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.ContactSource);
    }
    /**
     * Gets or sets the department of the contact.
     *
     */
    get Department() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Department);
    }
    set Department(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Department, value);
    }
    /**
     * Gets or sets the generation of the contact.
     *
     */
    get Generation() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Generation);
    }
    set Generation(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Generation, value);
    }
    /**
     * Gets an indexed list of Instant Messaging addresses for the contact.
     * For example, to set the first IM address, use the following syntax: ImAddresses[ImAddressKey.ImAddress1] = "john.doe@contoso.com"
     *
     */
    get ImAddresses() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.ImAddresses);
    }
    /**
     * Gets or sets the contact's job title.
     *
     */
    get JobTitle() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.JobTitle);
    }
    set JobTitle(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.JobTitle, value);
    }
    /**
     * Gets or sets the name of the contact's manager.
     *
     */
    get Manager() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Manager);
    }
    set Manager(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Manager, value);
    }
    /**
     * Gets or sets the mileage for the contact.
     *
     */
    get Mileage() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Mileage);
    }
    set Mileage(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Mileage, value);
    }
    /**
     * Gets or sets the location of the contact's office.
     *
     */
    get OfficeLocation() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.OfficeLocation);
    }
    set OfficeLocation(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.OfficeLocation, value);
    }
    /**
     * Gets or sets the index of the contact's postal address. When set, PostalAddressIndex refers to an entry in the PhysicalAddresses indexed list.
     *
     */
    get PostalAddressIndex() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.PostalAddressIndex);
    }
    set PostalAddressIndex(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.PostalAddressIndex, value);
    }
    /**
     * Gets or sets the contact's profession.
     *
     */
    get Profession() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Profession);
    }
    set Profession(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Profession, value);
    }
    /**
     * Gets or sets the name of the contact's spouse.
     *
     */
    get SpouseName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.SpouseName);
    }
    set SpouseName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.SpouseName, value);
    }
    /**
     * Gets or sets the surname of the contact.
     *
     */
    get Surname() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Surname);
    }
    set Surname(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.Surname, value);
    }
    /**
     * Gets or sets the date of the contact's wedding anniversary.
     *
     */
    get WeddingAnniversary() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.WeddingAnniversary);
    }
    set WeddingAnniversary(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.WeddingAnniversary, value);
    }
    /**
     * Gets a value indicating whether this contact has a picture associated with it.
     *
     */
    get HasPicture() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.HasPicture);
    }
    /**
     * Gets the full phonetic name from the directory
     *
     */
    get PhoneticFullName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.PhoneticFullName);
    }
    /**
     * Gets the phonetic first name from the directory
     *
     */
    get PhoneticFirstName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.PhoneticFirstName);
    }
    /**
     * Gets the phonetic last name from the directory
     *
     */
    get PhoneticLastName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.PhoneticLastName);
    }
    /**
     * Gets the Alias from the directory
     *
     */
    get Alias() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Alias);
    }
    /**
     * Get the Notes from the directory
     *
     */
    get Notes() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Notes);
    }
    /**
     * Gets the Photo from the directory **Unstable: needs testing**
     *
     */
    get DirectoryPhoto() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.Photo);
    }
    /**
     * Gets the User SMIME certificate from the directory **Unstable: needs testing**
     * //ref: cant use bytearray, using base64 decoded string instead -  number[][]
     *
     */
    get UserSMIMECertificate() {
        var byteArrayArray = this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.UserSMIMECertificate);
        return byteArrayArray.Content;
    }
    /**
     * Gets the MSExchange certificate from the directory **Unstable: needs testing**
     * //ref: cant use bytearray, using base64 decoded string instead -  number[][]
     *
     */
    get MSExchangeCertificate() {
        var byteArrayArray = this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.MSExchangeCertificate);
        return byteArrayArray.Content;
    }
    /**
     * Gets the DirectoryID as Guid or DN string
     *
     */
    get DirectoryId() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.DirectoryId);
    }
    /**
     * Gets the manager mailbox information
     *
     */
    get ManagerMailbox() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.ManagerMailbox);
    }
    /**
     * Get the direct reports mailbox information
     *
     */
    get DirectReports() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.DirectReports);
    }
    // Bind(service: ExchangeService, id: ItemId, propertySet: PropertySet = PropertySet.FirstClassProperties): Promise<Contact> { //removed
    //     return Contact.Bind(service, id, propertySet);
    // }
    static Bind(service, id, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        return service.BindToItem(id, propertySet, Contact);
    }
    /**
     * Retrieves the file attachment that holds the contact's picture. **Unstable: needs testing**
     *
     * @return  {FileAttachment}      The file attachment that holds the contact's picture.
     */
    GetContactPictureAttachment() {
        EwsUtilities_1.EwsUtilities.ValidateMethodVersion(this.Service, ExchangeVersion_1.ExchangeVersion.Exchange2010, "GetContactPictureAttachment");
        if (!this.PropertyBag.IsPropertyLoaded(Schemas_1.Schemas.ContactSchema.Attachments)) {
            throw new PropertyException_1.PropertyException(Strings_1.Strings.AttachmentCollectionNotLoaded);
        }
        for (var attachment of this.Attachments.Items) {
            //todo: implement typecasting
            var fileAttachment = attachment;
            if (fileAttachment.IsContactPhoto) {
                return fileAttachment;
            }
        }
        return null;
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() { return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1; }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() { return Schemas_1.Schemas.ContactSchema.Instance; }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.Contact; }
    /**
     * Removes the picture from local attachment collection.     *
     */
    InternalRemoveContactPicture() {
        // Iterates in reverse order to remove file attachments that have IsContactPhoto set to true.
        for (var index = this.Attachments.Count - 1; index >= 0; index--) {
            //todo: implement safe typecasting
            var fileAttachment = this.Attachments._getItem(index);
            if (fileAttachment != null) {
                if (fileAttachment.IsContactPhoto) {
                    this.Attachments.Remove(fileAttachment);
                }
            }
        }
    }
    /**
     * Removes the contact's picture.     *
     */
    RemoveContactPicture() {
        EwsUtilities_1.EwsUtilities.ValidateMethodVersion(this.Service, ExchangeVersion_1.ExchangeVersion.Exchange2010, "RemoveContactPicture");
        if (!this.PropertyBag.IsPropertyLoaded(Schemas_1.Schemas.ContactSchema.Attachments)) {
            throw new PropertyException_1.PropertyException(Strings_1.Strings.AttachmentCollectionNotLoaded);
        }
        this.InternalRemoveContactPicture();
    }
    //ref: //todo: Not Implemented
    //SetContactPicture(contentStream: any /*System.IO.Stream*/): any { throw new Error("Contact.ts - SetContactPicture : Not implemented."); }
    //SetContactPicture(content: number[] /*System.Byte[]*/): any { throw new Error("Contact.ts - SetContactPicture : Not implemented."); }
    //SetContactPicture(fileName: string): any { throw new Error("Contact.ts - SetContactPicture : Not implemented."); }
    /**
     * Sets the contact's picture using the base64 content of file.
     *
     * @param   {string}    base64Content       base64 content of picture attachment.
     * @param   {string}    attachmentName      name of the picture attachment.
     *
     */
    SetContactPicture(base64Content, attachmentName) {
        EwsUtilities_1.EwsUtilities.ValidateMethodVersion(this.Service, ExchangeVersion_1.ExchangeVersion.Exchange2010, "SetContactPicture");
        this.InternalRemoveContactPicture();
        let fileAttachment = this.Attachments.AddFileAttachment(attachmentName, base64Content);
        fileAttachment.IsContactPhoto = true;
    }
    /**
     * @internal Validates this instance.     *
     */
    Validate() {
        super.Validate();
        var fileAsMapping = { outValue: null };
        if (this.TryGetProperty(Schemas_1.Schemas.ContactSchema.FileAsMapping, fileAsMapping)) {
            // FileAsMapping is extended by 5 new values in 2010 mode. Validate that they are used according the version.
            EwsUtilities_1.EwsUtilities.ValidateEnumVersionValue(FileAsMapping_1.FileAsMapping, fileAsMapping.outValue, this.Service.RequestedServerVersion, "FileAsMapping");
        }
    }
}
exports.Contact = Contact;
Contact.ContactPictureName = "ContactPicture.jpg";
//# sourceMappingURL=Contact.js.map