"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContactGroup = void 0;
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertySet_1 = require("../../PropertySet");
const Schemas_1 = require("../Schemas/Schemas");
const ServiceObjectPropertyException_1 = require("../../../Exceptions/ServiceObjectPropertyException");
const Strings_1 = require("../../../Strings");
const XmlElementNames_1 = require("../../XmlElementNames");
const Item_1 = require("./Item");
/**
 * Represents a Contact Group. Properties available on contact groups are defined in the ContactGroupSchema class.
 */
class ContactGroup extends Item_1.Item {
    /**
     * Gets the name under which this contact group is filed as.
     *
     * [RequiredServerVersion(ExchangeVersion.Exchange2010)]
     */
    get FileAs() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.FileAs);
    }
    /**
     * Gets or sets the display name of the contact group.
     */
    get DisplayName() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactSchema.DisplayName);
    }
    set DisplayName(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ContactSchema.DisplayName, value);
    }
    /**
     * Gets the members of the contact group.
     *
     * [RequiredServerVersion(ExchangeVersion.Exchange2010)]
     */
    get Members() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ContactGroupSchema.Members);
    }
    constructor(serviceOrParentAttachment) {
        super(serviceOrParentAttachment);
    }
    static Bind(service, id, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        return service.BindToItem(id, propertySet, ContactGroup);
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() {
        return Schemas_1.Schemas.ContactGroupSchema.Instance;
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.DistributionList;
    }
    /**
     *  @internal Sets the subject.
     *
     * @param   {string}   subject   The subject.
     */
    SetSubject(subject) {
        // Set is disabled in client API even though it is implemented in protocol for Item.Subject.
        // Setting Subject out of sync with DisplayName breaks interop with OLK.
        throw new ServiceObjectPropertyException_1.ServiceObjectPropertyException(Strings_1.Strings.PropertyIsReadOnly, Schemas_1.Schemas.ContactGroupSchema.Subject);
    }
}
exports.ContactGroup = ContactGroup;
//# sourceMappingURL=ContactGroup.js.map