"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingCancellation = void 0;
const CalendarActionResults_1 = require("../../../Misc/CalendarActionResults");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertySet_1 = require("../../PropertySet");
const RemoveFromCalendar_1 = require("../ResponseObjects/RemoveFromCalendar");
const Schemas_1 = require("../Schemas/Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const MeetingMessage_1 = require("./MeetingMessage");
/**
 * Represents a meeting cancellation message. Properties available on meeting messages are defined in the MeetingMessageSchema class.
 */
class MeetingCancellation extends MeetingMessage_1.MeetingMessage {
    /**
     * Gets the start time of the appointment.
     */
    get Start() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingCancellationSchema.Start);
    }
    /**
     * Gets the end time of the appointment.
     */
    get End() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingCancellationSchema.End);
    }
    /**
     * Gets the location of this appointment.
     */
    get Location() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingCancellationSchema.Location);
    }
    /**
     * Gets the recurrence pattern for this meeting request.
     */
    get Recurrence() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Recurrence);
    }
    /**
     * Gets the Enhanced location object.
     */
    get EnhancedLocation() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingCancellationSchema.EnhancedLocation);
    }
    constructor(serviceOrParentAttachment) {
        super(serviceOrParentAttachment);
    }
    static Bind(service, id, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        return service.BindToItem(id, propertySet, MeetingCancellation);
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() {
        return Schemas_1.Schemas.MeetingCancellationSchema.Instance;
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.MeetingCancellation;
    }
    /**
     * Removes the meeting associated with the cancellation message from the user's calendar.
     *
     * @return  {Promise<CalendarActionResults>}      A CalendarActionResults object containing the various items that were created or modified as a results of this operation.
     */
    RemoveMeetingFromCalendar() {
        let removeFromCalendar = new RemoveFromCalendar_1.RemoveFromCalendar(this);
        return removeFromCalendar.InternalCreate(null, null).then((items) => {
            return new CalendarActionResults_1.CalendarActionResults(items);
        });
    }
}
exports.MeetingCancellation = MeetingCancellation;
//# sourceMappingURL=MeetingCancellation.js.map