"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingRequest = void 0;
const AcceptMeetingInvitationMessage_1 = require("../ResponseObjects/AcceptMeetingInvitationMessage");
const DeclineMeetingInvitationMessage_1 = require("../ResponseObjects/DeclineMeetingInvitationMessage");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertySet_1 = require("../../PropertySet");
const Schemas_1 = require("../Schemas/Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const MeetingMessage_1 = require("./MeetingMessage");
/**
 * Represents a meeting request that an attendee can accept or decline. Properties available on meeting requests are defined in the MeetingRequestSchema class.
 */
class MeetingRequest extends MeetingMessage_1.MeetingMessage {
    /**
     * Gets the type of this meeting request.
     */
    get MeetingRequestType() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingRequestSchema.MeetingRequestType);
    }
    /**
     * Gets the a value representing the intended free/busy status of the meeting.
     */
    get IntendedFreeBusyStatus() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingRequestSchema.IntendedFreeBusyStatus);
    }
    /**
     * Gets the change highlights of the meeting request.
     */
    get ChangeHighlights() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingRequestSchema.ChangeHighlights);
    }
    /**
     * Gets the Enhanced location object.
     */
    get EnhancedLocation() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.MeetingRequestSchema.EnhancedLocation);
    }
    /**
     * Gets the start time of the appointment.
     */
    get Start() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Start);
    }
    /**
     * Gets the end time of the appointment.
     */
    get End() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.End);
    }
    /**
     * Gets the original start time of this appointment.
     */
    get OriginalStart() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.OriginalStart);
    }
    /**
     * Gets a value indicating whether this appointment is an all day event.
     */
    get IsAllDayEvent() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.IsAllDayEvent);
    }
    /**
     * Gets a value indicating the free/busy status of the owner of this appointment.
     */
    get LegacyFreeBusyStatus() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.LegacyFreeBusyStatus);
    }
    /**
     * Gets the location of this appointment.
     */
    get Location() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Location);
    }
    /**
     * Gets a text indicating when this appointment occurs.
     * The text returned by When is localized using the Exchange Server culture or using the culture specified in the PreferredCulture property of the ExchangeService object this appointment is bound to.
     */
    get When() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.When);
    }
    /**
     * Gets a value indicating whether the appointment is a meeting.
     */
    get IsMeeting() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.IsMeeting);
    }
    /**
     * Gets a value indicating whether the appointment has been cancelled.
     */
    get IsCancelled() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.IsCancelled);
    }
    /**
     * Gets a value indicating whether the appointment is recurring.
     */
    get IsRecurring() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.IsRecurring);
    }
    /**
     * Gets a value indicating whether the meeting request has already been sent.
     */
    get MeetingRequestWasSent() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.MeetingRequestWasSent);
    }
    /**
     * Gets a value indicating the type of this appointment.
     */
    get AppointmentType() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.AppointmentType);
    }
    /**
     * Gets a value indicating what was the last response of the user that loaded this meeting.
     */
    get MyResponseType() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.MyResponseType);
    }
    /**
     * Gets the organizer of this meeting.
     */
    get Organizer() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Organizer);
    }
    /**
     * Gets a list of required attendees for this meeting.
     */
    get RequiredAttendees() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.RequiredAttendees);
    }
    /**
     * Gets a list of optional attendeed for this meeting.
     */
    get OptionalAttendees() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.OptionalAttendees);
    }
    /**
     * Gets a list of resources for this meeting.
     */
    get Resources() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Resources);
    }
    /**
     * Gets the number of calendar entries that conflict with this appointment in the authenticated user's calendar.
     */
    get ConflictingMeetingCount() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.ConflictingMeetingCount);
    }
    /**
     * Gets the number of calendar entries that are adjacent to this appointment in the authenticated user's calendar.
     */
    get AdjacentMeetingCount() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.AdjacentMeetingCount);
    }
    /**
     * Gets a list of meetings that conflict with this appointment in the authenticated user's calendar.
     */
    get ConflictingMeetings() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.ConflictingMeetings);
    }
    /**
     * Gets a list of meetings that are adjucent to this appointment in the authenticated user's calendar.
     */
    get AdjacentMeetings() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.AdjacentMeetings);
    }
    /**
     * Gets the duration of this appointment.
     */
    get Duration() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Duration);
    }
    /**
     * Gets the name of the time zone this appointment is defined in.
     */
    get TimeZone() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.TimeZone);
    }
    /**
     * Gets the time when the attendee replied to the meeting request.
     */
    get AppointmentReplyTime() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.AppointmentReplyTime);
    }
    /**
     * Gets the sequence number of this appointment.
     */
    get AppointmentSequenceNumber() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.AppointmentSequenceNumber);
    }
    /**
     * Gets the state of this appointment.
     */
    get AppointmentState() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.AppointmentState);
    }
    /**
     * Gets the recurrence pattern for this meeting request.
     */
    get Recurrence() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.Recurrence);
    }
    /**
     * Gets an OccurrenceInfo identifying the first occurrence of this meeting.
     */
    get FirstOccurrence() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.FirstOccurrence);
    }
    /**
     * Gets an OccurrenceInfo identifying the last occurrence of this meeting.
     */
    get LastOccurrence() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.LastOccurrence);
    }
    /**
     * Gets a list of modified occurrences for this meeting.
     */
    get ModifiedOccurrences() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.ModifiedOccurrences);
    }
    /**
     * Gets a list of deleted occurrences for this meeting.
     */
    get DeletedOccurrences() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.DeletedOccurrences);
    }
    /**
     * Gets time zone of the start property of this meeting request.
     */
    get StartTimeZone() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.StartTimeZone);
    }
    /**
     * Gets time zone of the end property of this meeting request.
     */
    get EndTimeZone() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.EndTimeZone);
    }
    /**
     * Gets the type of conferencing that will be used during the meeting.
     */
    get ConferenceType() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.ConferenceType);
    }
    /**
     * Gets a value indicating whether new time proposals are allowed for attendees of this meeting.
     */
    get AllowNewTimeProposal() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.AllowNewTimeProposal);
    }
    /**
     * Gets a value indicating whether this is an online meeting.
     */
    get IsOnlineMeeting() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.IsOnlineMeeting);
    }
    /**
     * Gets the URL of the meeting workspace. A meeting workspace is a shared Web site for planning meetings and tracking results.
     */
    get MeetingWorkspaceUrl() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.MeetingWorkspaceUrl);
    }
    /**
     * Gets the URL of the Microsoft NetShow online meeting.
     */
    get NetShowUrl() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.AppointmentSchema.NetShowUrl);
    }
    constructor(parentAttachmentOrService) {
        super(parentAttachmentOrService);
    }
    /**
     * Accepts the meeting. Calling this method results in a call to EWS.
     *
     * @param   {boolean}   sendResponse   Indicates whether to send a response to the organizer.
     * @return  {Promise<CalendarActionResults>}   A CalendarActionResults object containing the various items that were created or modified as a results of this operation    :Promise.
     */
    Accept(sendResponse) {
        return this.InternalAccept(false, sendResponse);
    }
    /**
     * Tentatively accepts the meeting. Calling this method results in a call to EWS.
     *
     * @param   {boolean}   sendResponse   Indicates whether to send a response to the organizer.
     * @return  {Promise<CalendarActionResults>}       A CalendarActionResults object containing the various items that were created or modified as a results of this operation    :Promise.
     */
    AcceptTentatively(sendResponse) {
        return this.InternalAccept(true, sendResponse);
    }
    static Bind(service, id, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        return service.BindToItem(id, propertySet, MeetingRequest);
    }
    /**
     * Creates a local meeting acceptance message that can be customized and sent.
     *
     * @param   {boolean}   tentative   Specifies whether the meeting will be tentatively accepted.
     * @return  {AcceptMeetingInvitationMessage}        An AcceptMeetingInvitationMessage representing the meeting acceptance message.
     */
    CreateAcceptMessage(tentative) {
        return new AcceptMeetingInvitationMessage_1.AcceptMeetingInvitationMessage(this, tentative);
    }
    /**
     * Creates a local meeting declination message that can be customized and sent.
     *
     * @return  {DeclineMeetingInvitationMessage}      A DeclineMeetingInvitation representing the meeting declination message.
     */
    CreateDeclineMessage() {
        return new DeclineMeetingInvitationMessage_1.DeclineMeetingInvitationMessage(this);
    }
    /**
     * Declines the meeting invitation. Calling this method results in a call to EWS.
     *
     * @param   {boolean}   sendResponse   Indicates whether to send a response to the organizer.
     * @return  {Promise<CalendarActionResults>}       A CalendarActionResults object containing the various items that were created or modified as a results of this operation    :Promise.
     */
    Decline(sendResponse) {
        let decline = this.CreateDeclineMessage();
        if (sendResponse) {
            return decline.SendAndSaveCopy();
        }
        else {
            return decline.Save();
        }
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() {
        return Schemas_1.Schemas.MeetingRequestSchema.Instance;
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.MeetingRequest;
    }
    /**
     * @internal Accepts the meeting.
     *
     * @param   {boolean}   tentative      True if tentative accept.
     * @param   {boolean}   sendResponse   Indicates whether to send a response to the organizer.
     * @return  {Promise<CalendarActionResults>}       A CalendarActionResults object containing the various items that were created or modified as a results of this operation    :Promise.
     */
    InternalAccept(tentative, sendResponse) {
        let accept = this.CreateAcceptMessage(tentative);
        if (sendResponse) {
            return accept.SendAndSaveCopy();
        }
        else {
            return accept.Save();
        }
    }
}
exports.MeetingRequest = MeetingRequest;
//# sourceMappingURL=MeetingRequest.js.map