"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Task = void 0;
const AffectedTaskOccurrence_1 = require("../../../Enumerations/AffectedTaskOccurrence");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const MessageDisposition_1 = require("../../../Enumerations/MessageDisposition");
const PropertySet_1 = require("../../PropertySet");
const Schemas_1 = require("../Schemas/Schemas");
const XmlElementNames_1 = require("../../XmlElementNames");
const Item_1 = require("./Item");
/**
 * Represents a Task item. Properties available on tasks are defined in the TaskSchema class.
 */
class Task extends Item_1.Item {
    /** required to check [Attachable] attribute, AttachmentCollection.AddItemAttachment<TItem>() checks for non inherited [Attachable] attribute. */
    static get Attachable() { return this.name === "Task"; }
    ;
    /**
     * @nullable Gets or sets the actual amount of time that is spent on the task.
     */
    get ActualWork() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.ActualWork);
    }
    set ActualWork(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.ActualWork, value);
    }
    /**
     * @nullable Gets the date and time the task was assigned.
     */
    get AssignedTime() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.AssignedTime);
    }
    /**
     * Gets or sets the billing information of the task.
     */
    get BillingInformation() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.BillingInformation);
    }
    set BillingInformation(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.BillingInformation, value);
    }
    /**
     * Gets the number of times the task has changed since it was created.
     */
    get ChangeCount() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.ChangeCount);
    }
    /**
     * Gets or sets a list of companies associated with the task.
     */
    get Companies() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Companies);
    }
    set Companies(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.Companies, value);
    }
    /**
     * @nullable Gets or sets the date and time on which the task was completed.
     */
    get CompleteDate() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.CompleteDate);
    }
    set CompleteDate(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.CompleteDate, value);
    }
    /**
     * Gets or sets a list of contacts associated with the task.
     */
    get Contacts() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Contacts);
    }
    set Contacts(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.Contacts, value);
    }
    /**
     * Gets the current delegation state of the task.
     */
    get DelegationState() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.DelegationState);
    }
    /**
     * Gets the name of the delegator of this task.
     */
    get Delegator() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Delegator);
    }
    /**
     * @nullable    Gets or sets the date and time on which the task is due.
     */
    get DueDate() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.DueDate);
    }
    set DueDate(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.DueDate, value);
    }
    /**
     * Gets a value indicating the mode of the task.
     */
    get Mode() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Mode);
    }
    /**
     * Gets a value indicating whether the task is complete.
     */
    get IsComplete() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.IsComplete);
    }
    /**
     * Gets a value indicating whether the task is recurring.
     */
    get IsRecurring() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.IsRecurring);
    }
    /**
     * Gets a value indicating whether the task is a team task.
     */
    get IsTeamTask() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.IsTeamTask);
    }
    /**
     * Gets or sets the mileage of the task.
     */
    get Mileage() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Mileage);
    }
    set Mileage(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.Mileage, value);
    }
    /**
     * Gets the name of the owner of the task.
     */
    get Owner() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Owner);
    }
    /**
     * Gets or sets the completeion percentage of the task. PercentComplete must be between 0 and 100.
     */
    get PercentComplete() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.PercentComplete);
    }
    set PercentComplete(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.PercentComplete, value);
    }
    /**
     * Gets or sets the recurrence pattern for this task. Available recurrence pattern classes include Recurrence.
     * DailyPattern, Recurrence.MonthlyPattern and Recurrence.YearlyPattern.
     */
    get Recurrence() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Recurrence);
    }
    set Recurrence(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.Recurrence, value);
    }
    /**
     * @nullable    Gets or sets the date and time on which the task starts.
     */
    get StartDate() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.StartDate);
    }
    set StartDate(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.StartDate, value);
    }
    /**
     * Gets or sets the status of the task.
     */
    get Status() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.Status);
    }
    set Status(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.Status, value);
    }
    /**
     * Gets a string representing the status of the task, localized according to the PreferredCulture property of the ExchangeService object the task is bound to.
     */
    get StatusDescription() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.StatusDescription);
    }
    /**
     * @nullable Gets or sets the total amount of work spent on the task.
     */
    get TotalWork() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.TaskSchema.TotalWork);
    }
    set TotalWork(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.TaskSchema.TotalWork, value);
    }
    /**
     * @internal    @nullable   Gets the default setting for how to treat affected task occurrences on Delete.
     */
    get DefaultAffectedTaskOccurrences() {
        return AffectedTaskOccurrence_1.AffectedTaskOccurrence.AllOccurrences;
    }
    constructor(serviceOrParentAttachment) {
        super(serviceOrParentAttachment);
    }
    static Bind(service, id, propertySet = PropertySet_1.PropertySet.FirstClassProperties) {
        return service.BindToItem(id, propertySet, Task);
    }
    /**
     * Deletes the current occurrence of a recurring task. After the current occurrence isdeleted, the task represents the next occurrence.
     * Developers should call Load to retrieve the new property values of the task.
     * Calling this method results in a call to EWS.
     *
     * @param   {DeleteMode}   deleteMode   The deletion mode.
     * @return  {Promise<void>}            :Promise.
     */
    DeleteCurrentOccurrence(deleteMode) {
        return this.InternalDelete(deleteMode, null, AffectedTaskOccurrence_1.AffectedTaskOccurrence.SpecifiedOccurrenceOnly);
    }
    /**
     * @internal Gets a value indicating whether a time zone SOAP header should be emitted in a CreateItem or UpdateItem request so this item can be property saved or updated.
     *
     * @param   {boolean}   isUpdateOperation   Indicates whether the operation being petrformed is an update operation.
     * @return  {boolean}   *true* if a time zone SOAP header should be emitted; otherwise, *false*.
     */
    GetIsTimeZoneHeaderRequired(isUpdateOperation) {
        return true;
    }
    /**
     * @internal Gets the minimum required server version.
     *
     * @return  {ExchangeVersion}      Earliest Exchange version in which this service object type is supported.
     */
    GetMinimumRequiredServerVersion() {
        return ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1;
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() {
        return Schemas_1.Schemas.TaskSchema.Instance;
    }
    /**
     * @internal Gets the element name of item in XML
     *
     * @return  {string} name of elelment
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.Task;
    }
    Update(conflictResolutionMode) {
        return this.InternalUpdate(null /* parentFolder */, conflictResolutionMode, MessageDisposition_1.MessageDisposition.SaveOnly, null);
    }
}
exports.Task = Task;
//# sourceMappingURL=Task.js.map