"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CalendarResponseMessage = void 0;
const Schemas_1 = require("../Schemas/Schemas");
const CalendarResponseMessageBase_1 = require("./CalendarResponseMessageBase");
/**
 * Represents the base class for accept, tentatively accept and decline response messages.
 *
 * @typeparam   {TMessage}     The type of message that is created when this response message is saved.
 */
class CalendarResponseMessage extends CalendarResponseMessageBase_1.CalendarResponseMessageBase {
    /**
     * Gets or sets the body of the response.
     */
    get Body() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ItemSchema.Body);
    }
    set Body(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ItemSchema.Body, value);
    }
    /**
     * Gets a list of recipients the response will be sent to.
     */
    get ToRecipients() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.EmailMessageSchema.ToRecipients);
    }
    /**
     * Gets a list of recipients the response will be sent to as Cc.
     */
    get CcRecipients() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.EmailMessageSchema.CcRecipients);
    }
    /**
     * Gets a list of recipients this response will be sent to as Bcc.
     */
    get BccRecipients() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.EmailMessageSchema.BccRecipients);
    }
    get ItemClass() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ItemSchema.ItemClass);
    }
    set ItemClass(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ItemSchema.ItemClass, value);
    }
    /**
     * Gets or sets the sensitivity of this response.
     */
    get Sensitivity() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ItemSchema.Sensitivity);
    }
    set Sensitivity(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.ItemSchema.Sensitivity, value);
    }
    /**
     * Gets a list of attachments to this response.
     */
    get Attachments() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ItemSchema.Attachments);
    }
    get InternetMessageHeaders() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.ItemSchema.InternetMessageHeaders);
    }
    /**
     * Gets or sets the sender of this response.
     */
    get Sender() {
        return this.PropertyBag._getItem(Schemas_1.Schemas.EmailMessageSchema.Sender);
    }
    set Sender(value) {
        this.PropertyBag._setItem(Schemas_1.Schemas.EmailMessageSchema.Sender, value);
    }
    /**
     * @internal Initializes a new instance of the **CalendarResponseMessage** class.
     *
     * @param   {Item}   referenceItem   The reference item.
     */
    constructor(referenceItem) {
        super(referenceItem);
    }
    /**
     * @internal Internal method to return the schema associated with this type of object.
     *
     * @return  {ServiceObjectSchema}      The schema associated with this type of object.
     */
    GetSchema() { return Schemas_1.Schemas.CalendarResponseObjectSchema.Instance; }
}
exports.CalendarResponseMessage = CalendarResponseMessage;
//# sourceMappingURL=CalendarResponseMessage.js.map