"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PostReplySchema = void 0;
const Schemas_1 = require("./Schemas");
const ServiceObjectSchema_1 = require("./ServiceObjectSchema");
/**
 * Represents PostReply schema definition.
 */
class PostReplySchema extends ServiceObjectSchema_1.ServiceObjectSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(PostReplySchema, Schemas_1.Schemas.ItemSchema.Subject);
        this.RegisterProperty(PostReplySchema, Schemas_1.Schemas.ItemSchema.Body);
        this.RegisterProperty(PostReplySchema, Schemas_1.Schemas.ResponseObjectSchema.ReferenceItemId);
        this.RegisterProperty(PostReplySchema, Schemas_1.Schemas.ResponseObjectSchema.BodyPrefix);
    }
}
exports.PostReplySchema = PostReplySchema;
/**
 * @internal Instance of **PostReplySchema**
 */
PostReplySchema.Instance = new PostReplySchema();
//# sourceMappingURL=PostReplySchema.js.map