"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseObjectSchema = void 0;
const ComplexPropertyDefinition_1 = require("../../../PropertyDefinitions/ComplexPropertyDefinition");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const ItemId_1 = require("../../../ComplexProperties/ItemId");
const MessageBody_1 = require("../../../ComplexProperties/MessageBody");
const PropertyDefinitionFlags_1 = require("../../../Enumerations/PropertyDefinitionFlags");
const XmlElementNames_1 = require("../../XmlElementNames");
const ServiceObjectSchema_1 = require("./ServiceObjectSchema");
/**
 * Represents ResponseObject schema definition.
 */
class ResponseObjectSchema extends ServiceObjectSchema_1.ServiceObjectSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(ResponseObjectSchema, ResponseObjectSchema.ReferenceItemId);
    }
}
exports.ResponseObjectSchema = ResponseObjectSchema;
/**
 * Defines the **ReferenceItemId** property.
 */
ResponseObjectSchema.ReferenceItemId = new ComplexPropertyDefinition_1.ComplexPropertyDefinition("ReferenceItemId", XmlElementNames_1.XmlElementNames.ReferenceItemId, PropertyDefinitionFlags_1.PropertyDefinitionFlags.AutoInstantiateOnRead | PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanSet, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1, () => { return new ItemId_1.ItemId(); });
/**
 * Defines the **BodyPrefix** property.
 */
ResponseObjectSchema.BodyPrefix = new ComplexPropertyDefinition_1.ComplexPropertyDefinition("NewBodyContent", XmlElementNames_1.XmlElementNames.NewBodyContent, PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanSet, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1, () => { return new MessageBody_1.MessageBody(); });
/**
 * @internal Instance of **ResponseObjectSchema**
 */
ResponseObjectSchema.Instance = new ResponseObjectSchema();
//# sourceMappingURL=ResponseObjectSchema.js.map