"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SearchFolderSchema = void 0;
const ComplexPropertyDefinition_1 = require("../../../PropertyDefinitions/ComplexPropertyDefinition");
const ExchangeVersion_1 = require("../../../Enumerations/ExchangeVersion");
const PropertyDefinitionFlags_1 = require("../../../Enumerations/PropertyDefinitionFlags");
const SearchFolderParameters_1 = require("../../../ComplexProperties/SearchFolderParameters");
const XmlElementNames_1 = require("../../XmlElementNames");
const FolderSchema_1 = require("./FolderSchema");
/**
 * Field URIs for search folders.
 */
var FieldUris;
(function (FieldUris) {
    FieldUris.SearchParameters = "folder:SearchParameters";
})(FieldUris || (FieldUris = {}));
/**
 * Represents the schema for search folders.
 */
class SearchFolderSchema extends FolderSchema_1.FolderSchema {
    /**
     * Registers properties.
     *
     * /remarks/    IMPORTANT NOTE: PROPERTIES MUST BE REGISTERED IN SCHEMA ORDER (i.e. the same order as they are defined in types.xsd)
     */
    RegisterProperties() {
        super.RegisterProperties();
        this.RegisterProperty(SearchFolderSchema, SearchFolderSchema.SearchParameters);
    }
}
exports.SearchFolderSchema = SearchFolderSchema;
/**
 * Defines the **SearchParameters** property.
 */
SearchFolderSchema.SearchParameters = new ComplexPropertyDefinition_1.ComplexPropertyDefinition("SearchParameters", XmlElementNames_1.XmlElementNames.SearchParameters, FieldUris.SearchParameters, PropertyDefinitionFlags_1.PropertyDefinitionFlags.AutoInstantiateOnRead | PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanSet | PropertyDefinitionFlags_1.PropertyDefinitionFlags.CanUpdate, ExchangeVersion_1.ExchangeVersion.Exchange2007_SP1, () => { return new SearchFolderParameters_1.SearchFolderParameters(); });
/**
 * @internal Instance of **SearchFolderSchema**
 */
SearchFolderSchema.Instance = new SearchFolderSchema();
//# sourceMappingURL=SearchFolderSchema.js.map