"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateInboxRulesException = void 0;
const ServiceRemoteException_1 = require("./ServiceRemoteException");
/**
 * Represents an exception thrown when an error occurs as a result of calling the UpdateInboxRules operation.
 *
 * @sealed
 */
class UpdateInboxRulesException extends ServiceRemoteException_1.ServiceRemoteException {
    /**
     * @internal Initializes a new instance of the **UpdateInboxRulesException** class.
     *
     * @param   {UpdateInboxRulesResponse}  serviceResponse   The rule operation service response.
     * @param   {RuleOperation[]}           ruleOperations    The original operations.
     */
    constructor(serviceResponse, ruleOperations) {
        super(serviceResponse && serviceResponse.ErrorMessage ? serviceResponse.ErrorMessage : "" || "");
        /**
         * ServiceResponse when service operation failed remotely.
         */
        this.serviceResponse = null;
        /**
         * Rule operation error collection.
         */
        this.errors = null;
        this.serviceResponse = serviceResponse;
        this.errors = serviceResponse.Errors;
        for (let error of this.errors.Items) {
            error.SetOperationByIndex(ruleOperations);
        }
    }
    /**
     * Gets the ServiceResponse for the exception.
     */
    get ServiceResponse() {
        return this.serviceResponse;
    }
    /**
     * Gets the rule operation error collection.
     */
    get Errors() {
        return this.errors;
    }
    /**
     * Gets the rule operation error code.
     */
    get ErrorCode() {
        return this.serviceResponse.ErrorCode;
    }
    /**
     * Gets the rule operation error message.
     */
    get ErrorMessage() {
        return this.serviceResponse.ErrorMessage;
    }
}
exports.UpdateInboxRulesException = UpdateInboxRulesException;
//# sourceMappingURL=UpdateInboxRulesException.js.map