"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MailboxSearchScope = void 0;
const MailboxSearchLocation_1 = require("../Enumerations/MailboxSearchLocation");
const MailboxSearchScopeType_1 = require("../Enumerations/MailboxSearchScopeType");
/**
 * Represents mailbox search scope object.
 */
class MailboxSearchScope {
    /**
     * Constructor
     *
     * @param   {string}   mailbox       Mailbox
     * @param   {MailboxSearchLocation}   searchScope   Search scope
     */
    constructor(mailbox, searchScope) {
        this.searchScope = MailboxSearchLocation_1.MailboxSearchLocation.All;
        this.scopeType = MailboxSearchScopeType_1.MailboxSearchScopeType.LegacyExchangeDN;
        /**
         * Mailbox
         */
        this.Mailbox = null;
        /**
         * Gets the extended data.
         *
         * @value The extended data.
         */
        this.ExtendedAttributes = null;
        this.Mailbox = mailbox;
        this.searchScope = searchScope;
        this.ExtendedAttributes = [];
    }
    /**
     * Search scope
     */
    get SearchScope() {
        return this.searchScope;
    }
    set SearchScope(value) {
        this.searchScope = value;
    }
    /**
     * @internal Search scope type
     */
    get SearchScopeType() {
        return this.scopeType;
    }
    set SearchScopeType(value) {
        this.scopeType = value;
    }
}
exports.MailboxSearchScope = MailboxSearchScope;
//# sourceMappingURL=MailboxSearchScope.js.map