"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LegacyAvailabilityTimeZoneTime = void 0;
const DateTime_1 = require("../../DateTime");
const DayOfTheWeek_1 = require("../../Enumerations/DayOfTheWeek");
const EwsUtilities_1 = require("../../Core/EwsUtilities");
const TimeSpan_1 = require("../../TimeSpan");
const TimeZoneInfo_1 = require("../../TimeZoneInfo");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const XmlNamespace_1 = require("../../Enumerations/XmlNamespace");
const ComplexProperty_1 = require("../../ComplexProperties/ComplexProperty");
class LegacyAvailabilityTimeZoneTime extends ComplexProperty_1.ComplexProperty {
    // private delta: TimeSpan /*System.TimeSpan*/; //backing property not needed
    // private year: number;
    // private month: number;
    // private dayOrder: number;
    // private dayOfTheWeek: DayOfTheWeek;
    // private timeOfDay: TimeSpan /*System.TimeSpan*/;
    constructor() {
        super();
        this.Delta = TimeSpan_1.TimeSpan.Zero /*System.TimeSpan*/;
        this.TimeOfDay = TimeSpan_1.TimeSpan.Zero /*System.TimeSpan*/;
        this.DayOrder = 0;
        this.Month = 0;
        this.DayOfTheWeek = DayOfTheWeek_1.DayOfTheWeek.Sunday;
        this.Year = 0;
    }
    get HasTransitionTime() { return this.Month >= 1 && this.Month <= 12; }
    ToTransitionTime() {
        if (this.Year == 0) {
            return TimeZoneInfo_1.TimeZoneInfo.TransitionTime.CreateFloatingDateRule(new DateTime_1.DateTime(DateTime_1.DateTime.MinValue.Year, DateTime_1.DateTime.MinValue.Month, DateTime_1.DateTime.MinValue.Day, this.TimeOfDay.Hours, this.TimeOfDay.Minutes, this.TimeOfDay.Seconds), this.Month, this.DayOrder, EwsUtilities_1.EwsUtilities.EwsToSystemDayOfWeek(this.DayOfTheWeek));
        }
        else {
            return TimeZoneInfo_1.TimeZoneInfo.TransitionTime.CreateFixedDateRule(new DateTime_1.DateTime(this.TimeOfDay.TotalMilliseconds), this.Month, this.DayOrder);
        }
    }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Bias:
                    this.Delta = TimeSpan_1.TimeSpan.FromMinutes(Number(jsonProperty[key]));
                    break;
                case XmlElementNames_1.XmlElementNames.Time:
                    this.TimeOfDay = new TimeSpan_1.TimeSpan(jsonProperty[key]); // momentjs taks care of parsing TimeSpan.Parse(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.DayOrder:
                    this.DayOrder = Number(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.DayOfWeek:
                    this.DayOfTheWeek = DayOfTheWeek_1.DayOfTheWeek[jsonProperty[key]];
                    break;
                case XmlElementNames_1.XmlElementNames.Month:
                    this.Month = Number(jsonProperty[key]);
                    break;
                case XmlElementNames_1.XmlElementNames.Year:
                    this.Year = Number(jsonProperty[key]);
                    break;
                default:
                    break;
            }
        }
    }
    /**@internal */
    WriteElementsToXml(writer) {
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Bias, this.Delta.TotalMinutes);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Time, EwsUtilities_1.EwsUtilities.TimeSpanToXSTime(this.TimeOfDay));
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DayOrder, this.DayOrder);
        writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Month, this.Month);
        // Only write DayOfWeek if this is a recurring time change
        if (this.Year == 0) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.DayOfWeek, DayOfTheWeek_1.DayOfTheWeek[this.DayOfTheWeek]); // needs to be string
        }
        // Only emit year if it's non zero, otherwise AS returns "Request is invalid"
        if (this.Year != 0) {
            writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Year, this.Year);
        }
    }
}
exports.LegacyAvailabilityTimeZoneTime = LegacyAvailabilityTimeZoneTime;
//# sourceMappingURL=LegacyAvailabilityTimeZoneTime.js.map