"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlternatePublicFolderItemId = void 0;
const IdFormat_1 = require("../../Enumerations/IdFormat");
const XmlAttributeNames_1 = require("../../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../../Core/XmlElementNames");
const AlternatePublicFolderId_1 = require("./AlternatePublicFolderId");
/**
 * Represents the Id of a public folder item expressed in a specific format.
 */
class AlternatePublicFolderItemId extends AlternatePublicFolderId_1.AlternatePublicFolderId {
    constructor(format = IdFormat_1.IdFormat.EwsLegacyId, folderId = null, itemId = null) {
        super(format, folderId);
        this.itemId = itemId;
    }
    /**
     * The Id of the public folder item.
     */
    get ItemId() {
        return this.itemId;
    }
    set ItemId(v) {
        this.itemId = v;
    }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() {
        return XmlElementNames_1.XmlElementNames.AlternatePublicFolderItemId;
    }
    /**
     * @internal Loads the attributes from Xml JsObject.
     *
     * @param   {any}   responseObject   The response object.
     */
    LoadAttributesFromXmlJsObject(responseObject) {
        super.LoadAttributesFromXmlJsObject(responseObject);
        this.itemId = responseObject[XmlAttributeNames_1.XmlAttributeNames.ItemId];
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.ItemId, this.ItemId);
    }
}
exports.AlternatePublicFolderItemId = AlternatePublicFolderItemId;
/**
 * @internal Schema type associated with AlternatePublicFolderItemId.
 */
AlternatePublicFolderItemId.SchemaTypeName = "AlternatePublicFolderItemIdType";
//# sourceMappingURL=AlternatePublicFolderItemId.js.map