"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemIdWrapperList = void 0;
const Item_1 = require("../Core/ServiceObjects/Items/Item");
const ItemId_1 = require("../ComplexProperties/ItemId");
const ItemIdWrapper_1 = require("./ItemIdWrapper");
const ItemWrapper_1 = require("./ItemWrapper");
/**
 * @internal Represents a list a abstracted item Ids.
 */
class ItemIdWrapperList {
    /**
     * @internal Initializes a new instance of the **ItemIdWrapperList** class.
     */
    constructor() {
        /**
         * List of ItemIdWrapper
         */
        this.itemIds = [];
    }
    /**
     * @internal Gets the count.
     *
     * @value   The count.
     */
    get Count() {
        return this.itemIds.length;
    }
    /**
     * Gets the *Item* at the specified index.
     *
     * @param   {number}   index   the index
     */
    _getItem(index) {
        return this.itemIds[index].GetItem();
    }
    Add(itemOrId) {
        if (itemOrId instanceof Item_1.Item)
            this.itemIds.push(new ItemWrapper_1.ItemWrapper(itemOrId));
        else if (itemOrId instanceof ItemId_1.ItemId)
            this.itemIds.push(new ItemIdWrapper_1.ItemIdWrapper(itemOrId));
        else
            throw new Error("FolderIdWrapperList.ts - Add - should not be seeing this.");
    }
    AddRange(itemsOrIds) {
        if (itemsOrIds != null) {
            for (var itemOrId of itemsOrIds) {
                this.Add(itemOrId);
            }
        }
    }
    /**
     *  Returns an enumerator that iterates through the collection. this case this.itemIds
     */
    GetEnumerator() {
        return this.itemIds;
    }
    /**
     * @internal Writes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer           The writer.
     * @param   {XmlNamespace}          ewsNamesapce     The ews namesapce.
     * @param   {string}                xmlElementName   Name of the XML element.
     */
    WriteToXml(writer, ewsNamesapce, xmlElementName) {
        if (this.Count > 0) {
            writer.WriteStartElement(ewsNamesapce, xmlElementName);
            for (var itemIdWrapper of this.itemIds) {
                itemIdWrapper.WriteToXml(writer);
            }
            writer.WriteEndElement();
        }
    }
}
exports.ItemIdWrapperList = ItemIdWrapperList;
//# sourceMappingURL=ItemIdWrapperList.js.map