"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ManagementRoles = void 0;
const XmlNamespace_1 = require("../Enumerations/XmlNamespace");
const XmlElementNames_1 = require("../Core/XmlElementNames");
//todo: json not implemented, should be done otherwise
class ManagementRoles {
    constructor(userRoles, applicationRoles) {
        if (userRoles) {
            this.userRoles = userRoles;
        }
        if (applicationRoles) {
            this.applicationRoles = applicationRoles;
        }
    }
    //ToJsonObject(): Microsoft.Exchange.WebServices.Data.JsonObject { throw new Error("ManagementRoles.ts - ToJsonObject : Not implemented."); }
    /**@internal */
    WriteRolesToXml(writer, roles, elementName) {
        if (roles && roles.length > 0) {
            writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, elementName);
            for (var role of roles) {
                writer.WriteElementValue(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.Role, role);
            }
            writer.WriteEndElement();
        }
    }
    /**@internal */
    WriteToXml(writer) {
        writer.WriteStartElement(XmlNamespace_1.XmlNamespace.Types, XmlElementNames_1.XmlElementNames.ManagementRole);
        this.WriteRolesToXml(writer, this.userRoles, XmlElementNames_1.XmlElementNames.UserRoles);
        this.WriteRolesToXml(writer, this.applicationRoles, XmlElementNames_1.XmlElementNames.ApplicationRoles);
        writer.WriteEndElement();
    }
}
exports.ManagementRoles = ManagementRoles;
//# sourceMappingURL=ManagementRoles.js.map