"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NameResolution = void 0;
const EmailAddress_1 = require("../ComplexProperties/EmailAddress");
const Contact_1 = require("../Core/ServiceObjects/Items/Contact");
const EwsLogging_1 = require("../Core/EwsLogging");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const PropertySet_1 = require("../Core/PropertySet");
class NameResolution {
    constructor(owner) {
        this.owner = null;
        this.mailbox = new EmailAddress_1.EmailAddress();
        this.contact = null;
        EwsLogging_1.EwsLogging.Assert(owner !== null, "NameResolution.ctor", "owner is null.");
        this.owner = owner;
    }
    get Mailbox() {
        return this.mailbox;
    }
    get Contact() {
        return this.contact;
    }
    LoadFromJson(jsonProperty, service) { throw new Error("NameResolution.ts - LoadFromJson : Not implemented."); }
    LoadFromXmlJsObject(jsonProperty, service) {
        for (var key in jsonProperty) {
            switch (key) {
                case XmlElementNames_1.XmlElementNames.Mailbox:
                    this.mailbox.LoadFromXmlJsObject(jsonProperty[key], service);
                    break;
                case XmlElementNames_1.XmlElementNames.Contact:
                    this.contact = new Contact_1.Contact(this.owner.Session);
                    this.contact.LoadFromXmlJsObject(jsonProperty[key], service, true, PropertySet_1.PropertySet.FirstClassProperties, false);
                    break;
                default:
                    break;
            }
        }
    }
}
exports.NameResolution = NameResolution;
//# sourceMappingURL=NameResolution.js.map