"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ItemEvent = void 0;
const EventType_1 = require("../Enumerations/EventType");
const FolderId_1 = require("../ComplexProperties/FolderId");
const ItemId_1 = require("../ComplexProperties/ItemId");
const JsonNames_1 = require("../Core/JsonNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const NotificationEvent_1 = require("./NotificationEvent");
/**
 * Represents an event that applies to an item.
 */
class ItemEvent extends NotificationEvent_1.NotificationEvent {
    /**
     * @internal Initializes a new instance of the **FolderEvent** class.
     *
     * @param   {EventType}		eventType   Type of the event.
     * @param   {DateTime}   	timestamp   The event timestamp.
     */
    constructor(eventType, timestamp) {
        super(eventType, timestamp);
        /**
         * Id of the item this event applies to.
         */
        this.itemId = null;
        /**
         * Id of the item that moved or copied. This is only meaningful when EventType is equal to either EventType.Moved or EventType.Copied.
         * For all other event types, it's null.
         */
        this.oldItemId = null;
    }
    /**
     * Gets the Id of the item this event applies to.
     */
    get ItemId() {
        return this.itemId;
    }
    /**
     * Gets the Id of the item that was moved or copied. OldItemId is only meaningful when EventType is equal to either EventType.Moved or EventType.Copied.
     * For all other event types, OldItemId is null.
     */
    get OldItemId() {
        return this.oldItemId;
    }
    /**
     * @internal Loads from XML.
     *
     * @param   {any}                 jsEvent                Json Object converted from XML.
     * @param   {ExchangeService}     service                The service.
     */
    LoadFromXmlJsObject(jsEvent, service) {
        this.itemId = new ItemId_1.ItemId();
        this.itemId.LoadFromXmlJsObject(jsEvent[XmlElementNames_1.XmlElementNames.ItemId], service);
        this.ParentFolderId = new FolderId_1.FolderId();
        this.ParentFolderId.LoadFromXmlJsObject(jsEvent[XmlElementNames_1.XmlElementNames.ParentFolderId], service);
        switch (this.EventType) {
            case EventType_1.EventType.Moved:
            case EventType_1.EventType.Copied:
                this.oldItemId = new ItemId_1.ItemId();
                this.oldItemId.LoadFromXmlJsObject(jsEvent[JsonNames_1.JsonNames.OldItemId], service);
                this.OldParentFolderId = new FolderId_1.FolderId();
                this.OldParentFolderId.LoadFromXmlJsObject(jsEvent[XmlElementNames_1.XmlElementNames.OldParentFolderId], service);
                break;
            default:
                break;
        }
    }
}
exports.ItemEvent = ItemEvent;
//# sourceMappingURL=ItemEvent.js.map