"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NotificationEventArgs = void 0;
/**
 * Provides data to a StreamingSubscriptionConnection's OnNotificationEvent event.
 */
class NotificationEventArgs {
    /**
     * @internal Initializes a new instance of the **NotificationEventArgs** class.
     *
     * @param   {StreamingSubscription}   	subscription   The subscription for which notifications have been received.
     * @param   {NotificationEvent[]}   	events         The events that were received.
     */
    constructor(subscription, events) {
        this.Events = events;
        this.Subscription = subscription;
    }
}
exports.NotificationEventArgs = NotificationEventArgs;
//# sourceMappingURL=NotificationEventArgs.js.map