"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BoolPropertyDefinition = void 0;
const ExtensionMethods_1 = require("../ExtensionMethods");
const EwsUtilities_1 = require("../Core/EwsUtilities");
const GenericPropertyDefinition_1 = require("./GenericPropertyDefinition");
/**
 * @internal Represents Boolean property definition
 */
class BoolPropertyDefinition extends GenericPropertyDefinition_1.GenericPropertyDefinition {
    constructor(propertyName, xmlElementName, uri, versionOrFlags, version, isNullable) {
        switch (arguments.length) {
            case 4:
                super(propertyName, xmlElementName, uri, versionOrFlags);
                break;
            case 5:
                super(propertyName, xmlElementName, uri, versionOrFlags, version, false);
                break;
            case 6:
                super(propertyName, xmlElementName, uri, versionOrFlags, version, isNullable);
                break;
            default:
                break;
        }
    }
    /**
     * @internal Parses the specified value (added to workaround Generic based value conversion in c#).
     *
     * @param   {string}    value   The value.
     * @return  {any}       Value of string.
     */
    Parse(value) {
        return ExtensionMethods_1.Convert.toBool(value);
    }
    /**
     * Convert instance to string.
     *
     * @param   {any}       value   The value.
     * @return  {string}    String representation of Boolean property.
     */
    ToString(value) {
        if (typeof value !== 'undefined')
            return EwsUtilities_1.EwsUtilities.BoolToXSBool(value);
        throw new Error("BoolPropertyDefinition: incorrect call of ToString(value): value is undefined");
    }
}
exports.BoolPropertyDefinition = BoolPropertyDefinition;
//# sourceMappingURL=BoolPropertyDefinition.js.map