"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ByteArrayPropertyDefinition = void 0;
const EwsLogging_1 = require("../Core/EwsLogging");
const TypedPropertyDefinition_1 = require("./TypedPropertyDefinition");
/**
 * @internal Represents byte array property definition.
 */
class ByteArrayPropertyDefinition extends TypedPropertyDefinition_1.TypedPropertyDefinition {
    /**
     * @internal Gets a value indicating whether this property definition is for a nullable type (ref, int?, bool?...).
     */
    get IsNullable() { return true; }
    /**
     * @internal Gets the property type.
     */
    get Type() { return ByteArrayPropertyDefinition; } //System.Type;
    /**
     * @internal Initializes a new instance of the **ByteArrayPropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version);
    }
    /**
     * @internal Parses the specified value.
     *
     * @param   {string}   value   The value.
     * @return  {any}           Byte array value.
     */
    Parse(value) {
        //ref: storing original base64 data base64Helper.atob(value); }
        EwsLogging_1.EwsLogging.Assert(false, "ByteArrayPropertyDefinition.Parse", "ByteArrayPropertyDefinition needs to be improved");
        return value;
    }
    /**
     * @internal Converts byte array property to a string.
     *
     * @param   {any}       value   The value.
     * @return  {string}    Byte array value.
     */
    ToString(value) {
        EwsLogging_1.EwsLogging.Assert(false, "ByteArrayPropertyDefinition.Parse", "ByteArrayPropertyDefinition needs to be improved");
        if (value)
            return value; //ref: using original value. base64Helper.btoa(value);
        throw new Error("ByteArrayPropertyDefinition: incorrect call of ToString(value): value is undefined");
    }
}
exports.ByteArrayPropertyDefinition = ByteArrayPropertyDefinition;
//# sourceMappingURL=ByteArrayPropertyDefinition.js.map