"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GenericPropertyDefinition = void 0;
const EwsLogging_1 = require("../Core/EwsLogging");
const TypeGuards_1 = require("../Interfaces/TypeGuards");
const TypedPropertyDefinition_1 = require("./TypedPropertyDefinition");
/**
 * @internal Represents generic property definition.
 */
class GenericPropertyDefinition extends TypedPropertyDefinition_1.TypedPropertyDefinition {
    constructor(propertyName, xmlElementName, uri, versionOrFlags, version, isNullableOrEnumType = false) {
        switch (arguments.length) {
            case 4:
                super(propertyName, xmlElementName, uri, versionOrFlags);
                break;
            case 6:
                if (typeof isNullableOrEnumType === 'boolean') {
                    super(propertyName, xmlElementName, uri, versionOrFlags, version, isNullableOrEnumType);
                }
                else {
                    super(propertyName, xmlElementName, uri, versionOrFlags, version);
                    this.enumType = isNullableOrEnumType;
                }
                break;
            default:
                break;
        }
    }
    /**
     * @internal Parses the specified value.
     *
     * @param   {string}    value   The value.
     * @return  {any}       Value of string.
     */
    Parse(value) {
        //todo: fix converting generictype
        if (TypeGuards_1.TypeGuards.hasEwsEnumAttribute(this.enumType)) {
            return this.enumType.FromEwsEnumString(value);
        }
        // if enum type is set, use this to get enum number instead of string
        if (this.enumType && typeof value === 'string') {
            return this.enumType[value];
        }
        EwsLogging_1.EwsLogging.Assert(false, "GenericPropertyDefinition<TPropertyValue>.Parse", "GenericPropertyDefinition<TPropertyValue> needs to be improved");
        return value;
    }
    /**
     * @internal Convert instance to string.
     *
     * @param   {any}   value   The value.
     * @return  {string}        String representation of property value.
     */
    ToString(value) {
        if (value === void 0 || value === null) {
            throw new Error("GenericPropertyDefinition: incorrect call of ToString(value): value is undefined/null");
        }
        if (TypeGuards_1.TypeGuards.hasEwsEnumAttribute(this.enumType)) {
            return this.enumType.ToEwsEnumString(value);
        }
        if (this.enumType && typeof value === "number") {
            return this.enumType[value];
        }
        return value.toString();
    }
    toString(value) {
        return this.ToString(value);
    }
}
exports.GenericPropertyDefinition = GenericPropertyDefinition;
//# sourceMappingURL=GenericPropertyDefinition.js.map