"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupMemberPropertyDefinition = void 0;
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtensionMethods_1 = require("../ExtensionMethods");
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const ServiceObjectPropertyDefinition_1 = require("./ServiceObjectPropertyDefinition");
/**
 * @internal Represents the definition of the GroupMember property.
 */
class GroupMemberPropertyDefinition extends ServiceObjectPropertyDefinition_1.ServiceObjectPropertyDefinition {
    constructor(key) {
        super(GroupMemberPropertyDefinition.FieldUri);
        /**
         * Member key. Maps to the Index attribute of IndexedFieldURI element.
         */
        this.key = null;
        if (arguments.length === 1) {
            this.key = key;
        }
    }
    /**
     * Gets or sets the member's key.
     */
    get Key() {
        return this.key;
    }
    set Key(value) {
        this.key = value;
    }
    /**
     * Gets the property type.
     */
    get Type() {
        return "String";
    }
    /**
     * @internal Gets the property definition's printable name.
     *
     * @return  {string}      The property definition's printable name.
     */
    GetPrintableName() { return ExtensionMethods_1.StringHelper.Format("{0}:{1}", GroupMemberPropertyDefinition.FieldUri, this.Key); }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.IndexedFieldURI; }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FieldIndex, this.Key);
    }
}
exports.GroupMemberPropertyDefinition = GroupMemberPropertyDefinition;
/**
 * FieldUri of IndexedFieldURI for a group member.
 */
GroupMemberPropertyDefinition.FieldUri = "distributionlist:Members:Member";
//# sourceMappingURL=GroupMemberPropertyDefinition.js.map