"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IndexedPropertyDefinition = void 0;
const XmlAttributeNames_1 = require("../Core/XmlAttributeNames");
const XmlElementNames_1 = require("../Core/XmlElementNames");
const ExtensionMethods_1 = require("../ExtensionMethods");
const ServiceObjectPropertyDefinition_1 = require("./ServiceObjectPropertyDefinition");
/**
 * Represents an indexed property definition.
 */
class IndexedPropertyDefinition extends ServiceObjectPropertyDefinition_1.ServiceObjectPropertyDefinition {
    /**
     * @internal Initializes a new instance of the **IndexedPropertyDefinition** class.
     *
     * @param   {string}   uri     The FieldURI attribute of the IndexedFieldURI element.
     * @param   {string}   index   The Index attribute of the IndexedFieldURI element.
     */
    constructor(uri, index) {
        super(uri);
        this.index = index;
    }
    /**
     * Gets the index of the property.
     */
    get Index() { return this.index; }
    get Type() { return 'string'; /*return typeof string;*/ } //System.Type;
    /**
     * Determines whether a given indexed property definition is equal to this indexed property definition.
     *
     * @param   {any}   obj   The object to check for equality.
     * @return  {boolean}         True if the properties definitions define the same indexed property.
     */
    Equals(obj) {
        var propertyDefinition = obj;
        return IndexedPropertyDefinition.IsEqualTo(propertyDefinition, this);
    }
    /**
     * Serves as a hash function for a particular type.
     *
     * @return  {number}      A hash code for the current System.Object.
     */
    GetHashCode() { throw new Error("IndexedPropertyDefinition.ts - GetHashCode : Not implemented."); }
    /**
     * @internal Gets the property definition's printable name.
     *
     * @return  {string}      The property definition's printable name.
     */
    GetPrintableName() { return ExtensionMethods_1.StringHelper.Format("{0}:{1}", this.Uri, this.Index); }
    /**
     * @internal Gets the name of the XML element.
     *
     * @return  {string}      XML element name.
     */
    GetXmlElementName() { return XmlElementNames_1.XmlElementNames.IndexedFieldURI; }
    /**
     * @internal Determines whether two specified instances of IndexedPropertyDefinition are equal.
     *
     * @param   {IndexedPropertyDefinition}    extPropDef1   First extended property definition.
     * @param   {IndexedPropertyDefinition}    extPropDef2   Second extended property definition.
     * @return  {boolean}                      True if extended property definitions are equal.
     */
    static IsEqualTo(idxPropDef1, idxPropDef2) {
        return idxPropDef1 === idxPropDef2 ||
            (idxPropDef1.Uri == idxPropDef2.Uri &&
                idxPropDef1.Index == idxPropDef2.Index);
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WriteAttributesToXml(writer) {
        super.WriteAttributesToXml(writer);
        writer.WriteAttributeValue(XmlAttributeNames_1.XmlAttributeNames.FieldIndex, this.Index);
    }
}
exports.IndexedPropertyDefinition = IndexedPropertyDefinition;
//# sourceMappingURL=IndexedPropertyDefinition.js.map