"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MeetingTimeZonePropertyDefinition = void 0;
const MeetingTimeZone_1 = require("../ComplexProperties/MeetingTimeZone");
const Schemas_1 = require("../Core/ServiceObjects/Schemas/Schemas");
const EwsLogging_1 = require("../Core/EwsLogging");
const PropertyDefinition_1 = require("./PropertyDefinition");
/**
 * @internal Represents the definition for the meeting time zone property.
 */
class MeetingTimeZonePropertyDefinition extends PropertyDefinition_1.PropertyDefinition {
    /**
     * @internal Initializes a new instance of the **MeetingTimeZonePropertyDefinition** class.
     *
     * @param   {string}                    propertyName     Name of the property (added to workaround reflection based initialization of Names).
     * @param   {string}                    xmlElementName   Name of the XML element.
     * @param   {string}                    uri              The URI.
     * @param   {PropertyDefinitionFlags}   flags            The flags.
     * @param   {ExchangeVersion}           version          The version.
     */
    constructor(propertyName, xmlElementName, uri, flags, version) {
        super(propertyName, xmlElementName, uri, flags, version);
    }
    /**
     * @internal Loads the property value from json.
     *
     * @param   {any}               jsObject         The JSON value.  Can be a JsonObject, string, number, bool, array, or null.
     * @param   {ExchangeService}   service       The service.
     * @param   {PropertyBag}       propertyBag   The property bag.
     */
    LoadPropertyValueFromXmlJsObject(jsObject, service, propertyBag) {
        EwsLogging_1.EwsLogging.Assert(false, "MeetingTimeZonePropertyDefinition.LoadPropertyValueFromXmlJsObject", "This is not properly validate, need to validate with example");
        if (jsObject != null) {
            var meetingTimeZone = new MeetingTimeZone_1.MeetingTimeZone();
            meetingTimeZone.LoadFromXmlJsObject(jsObject, service);
            propertyBag._setItem(Schemas_1.Schemas.AppointmentSchema.StartTimeZone, meetingTimeZone.ToTimeZoneInfo());
        }
    }
    /**
     * @internal Writes the attributes to XML.
     *
     * @param   {EwsServiceXmlWriter}   writer   The writer.
     */
    WritePropertyValueToXml(writer, propertyBag, isUpdateOperation) {
        var value = propertyBag._getItem(this);
        if (value) {
            value.WriteToXml(writer, this.XmlElementName);
        }
    }
}
exports.MeetingTimeZonePropertyDefinition = MeetingTimeZonePropertyDefinition;
//# sourceMappingURL=MeetingTimeZonePropertyDefinition.js.map